/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.pipe.modules.stacksize;

import de.ellpeck.prettypipes.Registry;
import de.ellpeck.prettypipes.items.IModule;
import de.ellpeck.prettypipes.items.ModuleItem;
import de.ellpeck.prettypipes.misc.ItemEquality;
import de.ellpeck.prettypipes.misc.ItemFilter;
import de.ellpeck.prettypipes.pipe.PipeBlockEntity;
import de.ellpeck.prettypipes.pipe.containers.AbstractPipeContainer;
import de.ellpeck.prettypipes.pipe.modules.stacksize.StackSizeModuleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class StackSizeModuleItem
extends ModuleItem {
    public StackSizeModuleItem() {
        super("stack_size_module");
    }

    public static int getMaxStackSizeForModule(ItemStack module) {
        int amount;
        if (module.m_41782_() && (amount = module.m_41783_().m_128451_("max_stack_size")) > 0) {
            return amount;
        }
        return 64;
    }

    public static void setMaxStackSize(ItemStack module, int amount) {
        module.m_41784_().m_128405_("max_stack_size", amount);
    }

    public static boolean getLimitToMaxStackSize(ItemStack module) {
        if (module.m_41782_()) {
            return module.m_41783_().m_128471_("limit_to_max_stack_size");
        }
        return false;
    }

    public static void setLimitToMaxStackSize(ItemStack module, boolean yes) {
        module.m_41784_().m_128379_("limit_to_max_stack_size", yes);
    }

    @Override
    public int getMaxInsertionAmount(ItemStack module, PipeBlockEntity tile, ItemStack stack, IItemHandler destination) {
        ItemEquality[] types = ItemFilter.getEqualityTypes(tile);
        int max = StackSizeModuleItem.getMaxStackSizeForModule(module);
        if (StackSizeModuleItem.getLimitToMaxStackSize(module)) {
            max = Math.min(max, stack.m_41741_());
        }
        int amount = 0;
        for (int i = 0; i < destination.getSlots(); ++i) {
            ItemStack stored = destination.getStackInSlot(i);
            if (stored.m_41619_() || !ItemEquality.compareItems(stored, stack, types) || (amount += stored.m_41613_()) < max) continue;
            return 0;
        }
        return max - amount;
    }

    @Override
    public boolean isCompatible(ItemStack module, PipeBlockEntity tile, IModule other) {
        return !(other instanceof StackSizeModuleItem);
    }

    @Override
    public boolean hasContainer(ItemStack module, PipeBlockEntity tile) {
        return true;
    }

    @Override
    public AbstractPipeContainer<?> getContainer(ItemStack module, PipeBlockEntity tile, int windowId, Inventory inv, Player player, int moduleIndex) {
        return new StackSizeModuleContainer(Registry.stackSizeModuleContainer, windowId, player, tile.m_58899_(), moduleIndex);
    }
}

