/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ShadowRenderHelper {
    private static final RenderType SHADOW_LAYER = RenderType.m_110482_((ResourceLocation)new ResourceLocation("textures/misc/shadow.png"));

    public static void renderShadow(PoseStack matrixStack, MultiBufferSource buffer, float opacity, float radius) {
        PoseStack.Pose entry = matrixStack.m_85850_();
        VertexConsumer builder = buffer.m_6299_(SHADOW_LAYER);
        ShadowRenderHelper.shadowVertex(entry, builder, opacity /= 2.0f, -1.0f * radius, 0.0f, -1.0f * radius, 0.0f, 0.0f);
        ShadowRenderHelper.shadowVertex(entry, builder, opacity, -1.0f * radius, 0.0f, 1.0f * radius, 0.0f, 1.0f);
        ShadowRenderHelper.shadowVertex(entry, builder, opacity, 1.0f * radius, 0.0f, 1.0f * radius, 1.0f, 1.0f);
        ShadowRenderHelper.shadowVertex(entry, builder, opacity, 1.0f * radius, 0.0f, -1.0f * radius, 1.0f, 0.0f);
    }

    public static void renderShadow(PoseStack matrixStack, MultiBufferSource buffer, LevelReader world, Vec3 pos, float opacity, float radius) {
        float f = radius;
        double d2 = pos.m_7096_();
        double d0 = pos.m_7098_();
        double d1 = pos.m_7094_();
        int i = Mth.m_14107_((double)(d2 - (double)f));
        int j = Mth.m_14107_((double)(d2 + (double)f));
        int k = Mth.m_14107_((double)(d0 - (double)f));
        int l = Mth.m_14107_((double)d0);
        int i1 = Mth.m_14107_((double)(d1 - (double)f));
        int j1 = Mth.m_14107_((double)(d1 + (double)f));
        PoseStack.Pose entry = matrixStack.m_85850_();
        VertexConsumer builder = buffer.m_6299_(SHADOW_LAYER);
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)new BlockPos(i, k, i1), (BlockPos)new BlockPos(j, l, j1))) {
            ShadowRenderHelper.renderBlockShadow(entry, builder, world, blockpos, d2, d0, d1, f, opacity);
        }
    }

    private static void renderBlockShadow(PoseStack.Pose entry, VertexConsumer builder, LevelReader world, BlockPos pos, double x, double y, double z, float radius, float opacity) {
        VoxelShape voxelshape;
        BlockPos blockpos = pos.m_7495_();
        BlockState blockstate = world.m_8055_(blockpos);
        if (blockstate.m_60799_() != RenderShape.INVISIBLE && world.m_46803_(pos) > 3 && blockstate.m_60838_((BlockGetter)world, blockpos) && !(voxelshape = blockstate.m_60808_((BlockGetter)world, pos.m_7495_())).m_83281_()) {
            float brightness = LightTexture.m_234316_((DimensionType)world.m_6042_(), (int)world.m_46803_(pos));
            float f = (float)(((double)opacity - (y - (double)pos.m_123342_()) / 2.0) * 0.5 * (double)brightness);
            if (f >= 0.0f) {
                if (f > 1.0f) {
                    f = 1.0f;
                }
                AABB AABB2 = voxelshape.m_83215_();
                double d0 = (double)pos.m_123341_() + AABB2.f_82288_;
                double d1 = (double)pos.m_123341_() + AABB2.f_82291_;
                double d2 = (double)pos.m_123342_() + AABB2.f_82289_;
                double d3 = (double)pos.m_123343_() + AABB2.f_82290_;
                double d4 = (double)pos.m_123343_() + AABB2.f_82293_;
                float f1 = (float)(d0 - x);
                float f2 = (float)(d1 - x);
                float f3 = (float)(d2 - y + 0.015625);
                float f4 = (float)(d3 - z);
                float f5 = (float)(d4 - z);
                float f6 = -f1 / 2.0f / radius + 0.5f;
                float f7 = -f2 / 2.0f / radius + 0.5f;
                float f8 = -f4 / 2.0f / radius + 0.5f;
                float f9 = -f5 / 2.0f / radius + 0.5f;
                ShadowRenderHelper.shadowVertex(entry, builder, f, f1, f3, f4, f6, f8);
                ShadowRenderHelper.shadowVertex(entry, builder, f, f1, f3, f5, f6, f9);
                ShadowRenderHelper.shadowVertex(entry, builder, f, f2, f3, f5, f7, f9);
                ShadowRenderHelper.shadowVertex(entry, builder, f, f2, f3, f4, f7, f8);
            }
        }
    }

    private static void shadowVertex(PoseStack.Pose entry, VertexConsumer builder, float alpha, float x, float y, float z, float u, float v) {
        builder.m_252986_(entry.m_252922_(), x, y, z).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(entry.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
    }
}

