/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.blocks.electricity.base.cables;

import com.drmangotea.tfmg.CreateTFMG;
import com.drmangotea.tfmg.base.MaxBlockVoltage;
import com.drmangotea.tfmg.base.TFMGTools;
import com.drmangotea.tfmg.base.TFMGUtils;
import com.drmangotea.tfmg.blocks.electricity.base.IHaveCables;
import com.drmangotea.tfmg.blocks.electricity.base.TFMGForgeEnergyStorage;
import com.drmangotea.tfmg.blocks.electricity.base.VoltageAlteringBlockEntity;
import com.drmangotea.tfmg.blocks.electricity.base.WallMountBlock;
import com.drmangotea.tfmg.blocks.electricity.base.cables.CableConnectorBlock;
import com.drmangotea.tfmg.blocks.electricity.base.cables.ElectricNetworkManager;
import com.drmangotea.tfmg.blocks.electricity.base.cables.ElectricalNetwork;
import com.drmangotea.tfmg.blocks.electricity.base.cables.EnergyNetworkUpdatePacket;
import com.drmangotea.tfmg.blocks.electricity.base.cables.IElectric;
import com.drmangotea.tfmg.blocks.electricity.base.cables.VoltagePacket;
import com.drmangotea.tfmg.blocks.electricity.base.cables.WireConnection;
import com.drmangotea.tfmg.blocks.electricity.base.cables.WireManager;
import com.drmangotea.tfmg.blocks.electricity.cable_blocks.CableHubBlockEntity;
import com.drmangotea.tfmg.blocks.electricity.energy_components.resistors.ResistorBlockEntity;
import com.drmangotea.tfmg.registry.TFMGBlockEntities;
import com.drmangotea.tfmg.registry.TFMGItems;
import com.drmangotea.tfmg.registry.TFMGPackets;
import com.simibubi.create.Create;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class CableConnectorBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation,
IElectric {
    public long network = this.getId();
    public Player player = null;
    public int voltage = 0;
    public boolean destroyed = false;
    public boolean networkUpdate = false;
    public boolean needsVoltageUpdate = false;
    public boolean breakNextTick = false;
    private LazyOptional<IEnergyStorage> lazyEnergyHandler = LazyOptional.empty();
    public final TFMGForgeEnergyStorage energy = this.createEnergyStorage();
    public ArrayList<WireConnection> wireConnections = new ArrayList();

    public CableConnectorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setLazyTickRate(10);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyEnergyHandler.invalidate();
    }

    public void useEnergy(int value) {
        this.energy.extractEnergy(value, false);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY && side == null) {
            return this.lazyEnergyHandler.cast();
        }
        if (cap == ForgeCapabilities.ENERGY && this.hasElectricitySlot(side)) {
            return this.lazyEnergyHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void lazyTick() {
        super.lazyTick();
        this.getOrCreateElectricNetwork().members.removeIf(member -> !(this.f_58857_.m_7702_(BlockPos.m_122022_((long)member.getId())) instanceof IElectric));
        this.getOrCreateElectricNetwork().members.removeIf(member -> member.getNetwork() != this.getNetwork());
        this.getOrCreateElectricNetwork().add(this);
        for (Direction direction : Direction.values()) {
            if (!this.hasElectricitySlot(direction)) continue;
            BlockEntity be = this.f_58857_.m_7702_(this.m_58899_().m_121945_(direction));
            if (be == null) {
                return;
            }
            LazyOptional capability = be.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_());
            if (!capability.isPresent() || !((IEnergyStorage)capability.orElseGet(null)).canReceive() || be instanceof IElectric) continue;
            this.getOrCreateElectricNetwork().requestEnergy(this);
            int maxTransfer1 = this.getForgeEnergy().extractEnergy(this.getForgeEnergy().getEnergyStored(), true);
            int maxTransfer2 = ((IEnergyStorage)capability.orElseGet(null)).receiveEnergy(this.getForgeEnergy().getEnergyStored(), true);
            int a = this.getForgeEnergy().extractEnergy(Math.min(maxTransfer1, maxTransfer2), false);
            ((IEnergyStorage)capability.orElseGet(null)).receiveEnergy(a, false);
        }
    }

    public void onLoad() {
        super.onLoad();
        this.lazyEnergyHandler = LazyOptional.of(() -> this.energy);
    }

    public void tick() {
        super.tick();
        if (this.breakNextTick) {
            this.explode();
        }
        if (this.getVoltage() > this.maxVoltage()) {
            this.voltageFailure();
        }
        if (this.FEProduction() > 0) {
            this.energy.receiveEnergy(this.FEProduction(), false);
        }
        if (this.networkUpdate) {
            this.getOrCreateElectricNetwork().updateNetworkVoltage();
            this.networkUpdate = false;
            this.sendData();
        }
        if (this.needsVoltageUpdate) {
            this.setVoltageFromNetwork();
            this.needsVoltageUpdate = false;
            this.sendData();
        }
        if (Create.RANDOM.nextBoolean()) {
            this.removeInvalidConnections();
        }
    }

    public void remove() {
        super.destroy();
        this.voltage = 0;
        this.destroyed = true;
        this.getOrCreateElectricNetwork().remove(this);
        ElectricNetworkManager.networks.get(this.m_58904_()).remove(this.getId());
        ElectricNetworkManager.networks.get(this.f_58857_).remove(this.getId());
        for (WireConnection wireConnection : this.wireConnections) {
            BlockPos pos = wireConnection.point1 == this.m_58899_() ? wireConnection.point2 : wireConnection.point1;
            BlockEntity blockEntity = this.f_58857_.m_7702_(pos);
            if (!(blockEntity instanceof IElectric)) continue;
            IElectric be = (IElectric)blockEntity;
            be.makeControllerAndSpread();
            be.getOrCreateElectricNetwork().updateNetworkVoltage();
            be.getOrCreateElectricNetwork().updateVoltageFromNetwork();
            if (!(be instanceof ResistorBlockEntity)) continue;
            be.getOrCreateElectricNetwork().voltage = 0;
        }
        ArrayList<WireConnection> list = new ArrayList<WireConnection>();
        for (WireConnection connection : this.wireConnections) {
            if (connection.neighborConnection) continue;
            list.add(connection);
        }
        ItemEntity itemEntity = new ItemEntity(this.f_58857_, (double)((float)this.m_58899_().m_123341_() + 0.5f), (double)((float)this.m_58899_().m_123342_() + 0.5f), (double)((float)this.m_58899_().m_123343_() + 0.5f), new ItemStack((ItemLike)TFMGItems.COPPER_CABLE.get(), list.size()));
        if (itemEntity.m_32055_().m_41613_() == 0) {
            return;
        }
        this.f_58857_.m_7967_((Entity)itemEntity);
        super.remove();
    }

    @Override
    public boolean outputAllowed() {
        return true;
    }

    public void changeToExtension() {
        BlockState state = this.f_58857_.m_8055_(this.m_58899_().m_121945_((Direction)this.m_58900_().m_61143_((Property)WallMountBlock.FACING)));
        if (state.m_60734_() == this.m_58900_().m_60734_()) {
            if (state.m_61143_((Property)WallMountBlock.FACING) == this.m_58900_().m_61143_((Property)WallMountBlock.FACING) && !((Boolean)this.m_58900_().m_61143_((Property)CableConnectorBlock.EXTENSION)).booleanValue()) {
                this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)CableConnectorBlock.EXTENSION, (Comparable)Boolean.valueOf(true)), 2);
            }
        } else if (((Boolean)this.m_58900_().m_61143_((Property)CableConnectorBlock.EXTENSION)).booleanValue()) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)CableConnectorBlock.EXTENSION, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    public void removeInvalidConnections() {
        this.wireConnections.removeIf(connection -> !(this.f_58857_.m_8055_(connection.point1).m_60734_() instanceof IHaveCables) || !(this.f_58857_.m_8055_(connection.point2).m_60734_() instanceof IHaveCables));
    }

    @Override
    public void makeControllerAndSpread() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.getOrCreateElectricNetwork().members.remove(this);
        CreateTFMG.NETWORK_MANAGER.getOrCreateNetworkFor(this);
        this.setNetwork(this.getId(), false);
        this.network = this.getId();
        this.onConnected();
    }

    @Override
    public TFMGForgeEnergyStorage getForgeEnergy() {
        return this.energy;
    }

    @Override
    public void onConnected() {
        this.needsVoltageUpdate = true;
        this.getOrCreateElectricNetwork().updateNetworkVoltage();
        for (WireConnection connection : this.wireConnections) {
            BlockPos pos = connection.point1 == this.m_58899_() ? connection.point2 : connection.point1;
            BlockEntity blockEntity = this.f_58857_.m_7702_(pos);
            if (!(blockEntity instanceof IElectric)) continue;
            IElectric be = (IElectric)blockEntity;
            if (be instanceof CableHubBlockEntity) {
                CableHubBlockEntity be1 = (CableHubBlockEntity)be;
                if (be1.hasSignal) continue;
            }
            if (be.getNetwork() != this.network && !be.destroyed() && be != this) {
                be.setNetwork(this.network, true);
                be.onConnected();
                continue;
            }
            if (!be.destroyed()) continue;
            this.getOrCreateElectricNetwork().remove(be);
        }
    }

    @Override
    public int FECapacity() {
        return 1000;
    }

    @Override
    public int FEProduction() {
        return 0;
    }

    @Override
    public int FETransferSpeed() {
        return 2500;
    }

    @Override
    public int getVoltage() {
        return this.voltage;
    }

    @Override
    public int voltageGeneration() {
        int voltageGeneration = 0;
        for (Direction direction : Direction.values()) {
            BlockEntity blockEntity;
            if (!this.hasElectricitySlot(direction) || !((blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(direction))) instanceof VoltageAlteringBlockEntity)) continue;
            VoltageAlteringBlockEntity be = (VoltageAlteringBlockEntity)blockEntity;
            if (be.voltage == 0 || !be.hasElectricitySlot(direction)) continue;
            voltageGeneration = Math.max(voltageGeneration, be.getOutputVoltage());
        }
        return voltageGeneration;
    }

    public void setVoltage(int value) {
        this.setVoltage(value, true);
    }

    @Override
    public void setVoltage(int value, boolean update) {
        this.voltage = value;
        if (update) {
            this.onVoltageChanged();
        }
    }

    @Override
    public void voltageFailure() {
        if (!this.getOrCreateElectricNetwork().blowFuse()) {
            this.voltage = 0;
            this.wireConnections = new ArrayList();
            this.breakNextTick = true;
        }
    }

    public void explode() {
        TFMGUtils.createFireExplosion(this.f_58857_, null, this.m_58899_(), 10, 0.1f);
        this.f_58857_.m_46961_(this.m_58899_(), false);
    }

    @Override
    public void setNetwork(long newNetwork, boolean removeNetwork) {
        if (this.network == newNetwork) {
            return;
        }
        if (removeNetwork) {
            ElectricNetworkManager.networks.get(this.m_58904_()).remove(this.network);
        } else {
            this.getOrCreateElectricNetwork().remove(this);
        }
        long oldNetwork = this.network;
        this.network = newNetwork;
        ElectricalNetwork network1 = CreateTFMG.NETWORK_MANAGER.getOrCreateNetworkFor((IElectric)this.f_58857_.m_7702_(BlockPos.m_122022_((long)this.network)));
        if (network1.members.contains(this)) {
            this.network = oldNetwork;
            return;
        }
        network1.add(this);
    }

    public void onPlaced() {
        this.voltage = 0;
        this.networkUpdate = true;
        this.connectNeighbors();
        this.setVoltage(this.voltageGeneration());
        if (!this.f_58857_.f_46443_) {
            TFMGPackets.getChannel().send(PacketDistributor.ALL.noArg(), (Object)new VoltagePacket(this.m_58899_()));
        }
        this.getOrCreateElectricNetwork().updateNetworkVoltage();
        this.needsNetworkUpdate();
    }

    @Override
    public void setVoltageFromNetwork() {
        this.setVoltage(Math.max(this.getOrCreateElectricNetwork().voltage, this.voltageGeneration()), false);
    }

    @Override
    public int maxVoltage() {
        return MaxBlockVoltage.MAX_VOLTAGES.get(TFMGBlockEntities.CABLE_CONNECTOR.get());
    }

    @Override
    public void connectNeighbors() {
        for (Direction direction : Direction.values()) {
            BlockPos pos;
            BlockEntity blockEntity;
            if (!this.hasElectricitySlot(direction) || !((blockEntity = this.f_58857_.m_7702_(pos = this.m_58899_().m_121945_(direction))) instanceof IElectric)) continue;
            IElectric be = (IElectric)blockEntity;
            if (be instanceof CableHubBlockEntity) {
                CableHubBlockEntity be1 = (CableHubBlockEntity)be;
                if (be1.hasSignal) continue;
            }
            if (!be.hasElectricitySlot(direction.m_122424_())) continue;
            be.addConnection(WireManager.Conductor.COPPER, this.m_58899_(), false, true);
            be.sendStuff();
            this.addConnection(WireManager.Conductor.COPPER, pos, false, true);
            this.sendData();
            this.m_6596_();
            if (this.f_58857_.f_46443_) {
                TFMGPackets.getChannel().send(PacketDistributor.ALL.noArg(), (Object)new EnergyNetworkUpdatePacket(this.m_58899_(), this.network));
                TFMGPackets.getChannel().send(PacketDistributor.ALL.noArg(), (Object)new VoltagePacket(this.m_58899_()));
            }
            be.makeControllerAndSpread();
        }
    }

    @Override
    public void needsVoltageUpdate() {
        this.needsVoltageUpdate = true;
    }

    @Override
    public boolean destroyed() {
        return this.destroyed;
    }

    @Override
    public void needsNetworkUpdate() {
        this.networkUpdate = true;
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128405_("Voltage", this.getVoltage());
        compound.m_128356_("Network", this.network);
        int value = 0;
        for (WireConnection connection : this.wireConnections) {
            connection.saveConnection(compound, ++value - 1);
        }
        compound.m_128405_("WireCount", this.wireConnections.toArray().length);
        compound.m_128405_("ForgeEnergy", this.getForgeEnergy().getEnergyStored());
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.voltage = compound.m_128451_("Voltage");
        this.addConnection(WireManager.Conductor.COPPER, this.m_58899_().m_6630_(2).m_122012_(), true, true);
        if (this.wireConnections.isEmpty()) {
            return;
        }
        this.wireConnections = new ArrayList();
        for (int i = 0; i < compound.m_128451_("WireCount"); ++i) {
            BlockPos pos = new BlockPos(compound.m_128451_("X1" + i), compound.m_128451_("Y1" + i), compound.m_128451_("Z1" + i));
            if (pos == this.m_58899_()) {
                pos = new BlockPos(compound.m_128451_("X2" + i), compound.m_128451_("Y2" + i), compound.m_128451_("Z2" + i));
            }
            this.addConnection(WireManager.Conductor.COPPER, pos, compound.m_128471_("ShouldRender" + i), compound.m_128471_("NeighborConnection" + i));
        }
        this.network = compound.m_128454_("Network");
        this.setNetwork(this.network, false);
        this.energy.setEnergy(compound.m_128451_("ForgeEnergy"));
    }

    public void onVoltageChanged() {
        this.getOrCreateElectricNetwork().updateNetworkVoltage();
        this.getOrCreateElectricNetwork().updateVoltageFromNetwork();
        if (!this.f_58857_.f_46443_) {
            TFMGPackets.getChannel().send(PacketDistributor.ALL.noArg(), (Object)new VoltagePacket(this.m_58899_()));
        }
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    protected AABB createRenderBoundingBox() {
        return new AABB(this.m_58899_()).m_82400_(30.0);
    }

    @Override
    public boolean addConnection(WireManager.Conductor material, BlockPos pos, boolean shouldRender, boolean neighborConnection) {
        float lenght = TFMGTools.getDistance(this.m_58899_(), pos, false);
        if (lenght < 25.0f) {
            this.wireConnections.add(new WireConnection(material, lenght, pos, this.m_58899_(), shouldRender, neighborConnection));
            this.sendData();
            this.m_6596_();
            return true;
        }
        this.sendData();
        this.m_6596_();
        return false;
    }

    @Override
    public boolean hasElectricitySlot(Direction direction) {
        return direction == ((Direction)this.m_58900_().m_61143_((Property)WallMountBlock.FACING)).m_122424_();
    }

    @Override
    public long getNetwork() {
        return this.network;
    }

    @Override
    public long getId() {
        return this.m_58899_().m_121878_();
    }

    @Override
    public ElectricalNetwork getOrCreateElectricNetwork() {
        if (this.f_58857_.m_7702_(BlockPos.m_122022_((long)this.network)) instanceof IElectric) {
            return CreateTFMG.NETWORK_MANAGER.getOrCreateNetworkFor((IElectric)this.f_58857_.m_7702_(BlockPos.m_122022_((long)this.network)));
        }
        return CreateTFMG.NETWORK_MANAGER.getOrCreateNetworkFor(this);
    }

    @Override
    public void setNetworkClient(long value) {
        this.network = value;
    }

    @Override
    public void sendStuff() {
        this.sendData();
        this.m_6596_();
    }
}

