/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.redstone;

import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.core.redstone.RedstoneAccess;
import java.util.Arrays;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public final class RedstoneState
implements RedstoneAccess {
    @Nullable
    private final Runnable onOutputChanged;
    private final ReentrantLock outputLock = new ReentrantLock();
    @GuardedBy(value="outputLock")
    private boolean internalOutputChanged = false;
    @GuardedBy(value="outputLock")
    private final int[] internalOutput = new int[6];
    @GuardedBy(value="outputLock")
    private final int[] internalBundledOutput = new int[6];
    private final int[] externalOutput = new int[6];
    private final int[] externalBundledOutput = new int[6];
    private final ReentrantLock inputLock = new ReentrantLock();
    private boolean inputChanged = false;
    @GuardedBy(value="inputLock")
    private final int[] input = new int[6];
    @GuardedBy(value="inputLock")
    private final int[] bundledInput = new int[6];

    public RedstoneState() {
        this(null);
    }

    public RedstoneState(@Nullable Runnable outputChanged) {
        this.onOutputChanged = outputChanged;
    }

    @Override
    public int getInput(ComputerSide side) {
        this.inputLock.lock();
        try {
            int n = this.input[side.ordinal()];
            return n;
        }
        finally {
            this.inputLock.unlock();
        }
    }

    @Override
    public int getBundledInput(ComputerSide side) {
        this.inputLock.lock();
        try {
            int n = this.bundledInput[side.ordinal()];
            return n;
        }
        finally {
            this.inputLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOutput(ComputerSide side, int output) {
        int index = side.ordinal();
        this.outputLock.lock();
        try {
            if (this.internalOutput[index] == output) {
                return;
            }
            this.internalOutput[index] = output;
            this.setOutputChanged();
        }
        finally {
            this.outputLock.unlock();
        }
    }

    @Override
    public int getOutput(ComputerSide side) {
        this.outputLock.lock();
        try {
            int n = this.internalOutput[side.ordinal()];
            return n;
        }
        finally {
            this.outputLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBundledOutput(ComputerSide side, int output) {
        int index = side.ordinal();
        this.outputLock.lock();
        try {
            if (this.internalBundledOutput[index] == output) {
                return;
            }
            this.internalBundledOutput[index] = output;
            this.setOutputChanged();
        }
        finally {
            this.outputLock.unlock();
        }
    }

    @Override
    public int getBundledOutput(ComputerSide side) {
        this.outputLock.lock();
        try {
            int n = this.internalBundledOutput[side.ordinal()];
            return n;
        }
        finally {
            this.outputLock.unlock();
        }
    }

    @GuardedBy(value="outputLock")
    private void setOutputChanged() {
        if (this.internalOutputChanged) {
            return;
        }
        this.internalOutputChanged = true;
        if (this.onOutputChanged != null) {
            this.onOutputChanged.run();
        }
    }

    public int updateOutput() {
        this.outputLock.lock();
        try {
            if (!this.internalOutputChanged) {
                int n = 0;
                return n;
            }
            int changed = 0;
            for (int i = 0; i < 6; ++i) {
                if (this.externalOutput[i] != this.internalOutput[i]) {
                    this.externalOutput[i] = this.internalOutput[i];
                    changed |= 1 << i;
                }
                if (this.externalBundledOutput[i] == this.internalBundledOutput[i]) continue;
                this.externalBundledOutput[i] = this.internalBundledOutput[i];
                changed |= 1 << i;
            }
            this.internalOutputChanged = false;
            int n = changed;
            return n;
        }
        finally {
            this.outputLock.unlock();
        }
    }

    public int getExternalOutput(ComputerSide side) {
        return this.externalOutput[side.ordinal()];
    }

    public int getExternalBundledOutput(ComputerSide side) {
        return this.externalBundledOutput[side.ordinal()];
    }

    public void clearOutput() {
        this.outputLock.lock();
        try {
            Arrays.fill(this.internalOutput, 0);
            Arrays.fill(this.internalBundledOutput, 0);
            this.internalOutputChanged = true;
        }
        finally {
            this.outputLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setInput(ComputerSide side, int level, int bundledState) {
        int index = side.ordinal();
        this.inputLock.lock();
        try {
            boolean changed = false;
            if (this.input[index] != level) {
                this.input[index] = level;
                changed = true;
            }
            if (this.bundledInput[index] != bundledState) {
                this.bundledInput[index] = bundledState;
                changed = true;
            }
            this.inputChanged |= changed;
            boolean bl = changed;
            return bl;
        }
        finally {
            this.inputLock.unlock();
        }
    }

    public boolean pollInputChanged() {
        boolean changed = this.inputChanged;
        this.inputChanged = false;
        return changed;
    }
}

