/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.api.stat;

import com.agricraft.agricraft.api.AgriRegistry;
import com.agricraft.agricraft.api.config.StatsConfig;
import com.agricraft.agricraft.api.stat.AgriStat;
import com.agricraft.agricraft.common.item.SeedBagItem;

public class AgriStatRegistry
extends AgriRegistry<AgriStat> {
    private static AgriStatRegistry INSTANCE;
    private final AgriStat gain = new AgriStat("gain", () -> StatsConfig.gainMin, () -> StatsConfig.gainMax, () -> StatsConfig.gainHidden, -16776961);
    private final AgriStat growth = new AgriStat("growth", () -> StatsConfig.growthMin, () -> StatsConfig.growthMax, () -> StatsConfig.growthHidden, -16711936);
    private final AgriStat strength = new AgriStat("strength", () -> StatsConfig.strengthMin, () -> StatsConfig.strengthMax, () -> StatsConfig.strengthHidden, -65536);
    private final AgriStat resistance = new AgriStat("resistance", () -> StatsConfig.resistanceMin, () -> StatsConfig.resistanceMax, () -> StatsConfig.resistanceHidden, -256);
    private final AgriStat fertility = new AgriStat("fertility", () -> StatsConfig.fertilityMin, () -> StatsConfig.fertilityMax, () -> StatsConfig.fertilityHidden, -33024);
    private final AgriStat mutativity = new AgriStat("mutativity", () -> StatsConfig.mutativityMin, () -> StatsConfig.mutativityMax, () -> StatsConfig.mutativityHidden, -16711681);

    public static AgriStatRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AgriStatRegistry();
            INSTANCE.add(AgriStatRegistry.INSTANCE.gain);
            INSTANCE.add(AgriStatRegistry.INSTANCE.growth);
            INSTANCE.add(AgriStatRegistry.INSTANCE.strength);
            INSTANCE.add(AgriStatRegistry.INSTANCE.resistance);
            INSTANCE.add(AgriStatRegistry.INSTANCE.fertility);
            INSTANCE.add(AgriStatRegistry.INSTANCE.mutativity);
        }
        return INSTANCE;
    }

    private AgriStatRegistry() {
    }

    public AgriStat gainStat() {
        return this.gain;
    }

    public AgriStat growthStat() {
        return this.growth;
    }

    public AgriStat strengthStat() {
        return this.strength;
    }

    public AgriStat fertilityStat() {
        return this.fertility;
    }

    public AgriStat resistanceStat() {
        return this.resistance;
    }

    public AgriStat mutativityStat() {
        return this.mutativity;
    }

    @Override
    public boolean add(AgriStat object) {
        boolean r = super.add(object);
        if (r) {
            SeedBagItem.addStatSorter(object);
        }
        return r;
    }
}

