/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.compat.jade;

import com.agricraft.agricraft.api.AgriApi;
import com.agricraft.agricraft.api.codecs.AgriSoil;
import com.agricraft.agricraft.api.crop.AgriCrop;
import com.agricraft.agricraft.api.requirement.AgriGrowthConditionRegistry;
import com.agricraft.agricraft.api.requirement.AgriGrowthResponse;
import com.agricraft.agricraft.api.stat.AgriStat;
import com.agricraft.agricraft.api.stat.AgriStatRegistry;
import com.agricraft.agricraft.common.block.CropBlock;
import com.agricraft.agricraft.common.util.LangUtils;
import java.util.Comparator;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;

@WailaPlugin
public class AgriCraftJadePlugin
implements IWailaPlugin {
    public void registerClient(IWailaClientRegistration registration) {
        registration.registerBlockComponent((IBlockComponentProvider)CropBlockComponentProvider.INSTANCE, CropBlock.class);
        registration.registerBlockComponent((IBlockComponentProvider)SoilComponentProvider.INSTANCE, Block.class);
    }

    public static class CropBlockComponentProvider
    implements IBlockComponentProvider {
        public static final CropBlockComponentProvider INSTANCE = new CropBlockComponentProvider();
        private static final ResourceLocation ID = new ResourceLocation("agricraft", "crop_block");

        private CropBlockComponentProvider() {
        }

        public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
            BlockEntity blockEntity = blockAccessor.getBlockEntity();
            if (blockEntity instanceof AgriCrop) {
                AgriCrop crop = (AgriCrop)blockEntity;
                if (crop.hasPlant()) {
                    iTooltip.add((Component)Component.m_237110_((String)"agricraft.tooltip.jade.growth", (Object[])new Object[]{crop.getGrowthPercent() * 100.0}));
                    if (blockAccessor.getPlayer().m_6144_()) {
                        AgriGrowthResponse response;
                        iTooltip.add((Component)Component.m_237115_((String)"agricraft.tooltip.jade.species").m_7220_(LangUtils.plantName(crop.getGenome().getSpeciesGene().getTrait())));
                        AgriStatRegistry.getInstance().stream().filter(stat -> !stat.isHidden()).map(stat -> crop.getGenome().getStatGene((AgriStat)stat)).sorted(Comparator.comparing(p -> p.getGene().getId())).map(genePair -> Component.m_237110_((String)("agricraft.tooltip.jade.stat." + genePair.getGene().getId()), (Object[])new Object[]{genePair.getTrait()})).forEach(arg_0 -> ((ITooltip)iTooltip).add(arg_0));
                        if (crop.m_58904_().f_46443_) {
                            crop.m_58904_().m_46465_();
                        }
                        iTooltip.add((Component)Component.m_237115_((String)("agricraft.tooltip.magnifying.requirement." + ((response = crop.getFertilityResponse()).isLethal() ? "lethal" : (response.isFertile() ? "fertile" : "not_fertile")))));
                        if (!response.isFertile()) {
                            int strength = crop.getGenome().getStrength();
                            AgriGrowthConditionRegistry.getInstance().stream().filter(condition -> !condition.check(crop, crop.m_58904_(), crop.m_58899_(), strength).isFertile()).forEach(condition -> condition.notMetDescription(arg_0 -> ((ITooltip)iTooltip).add(arg_0)));
                        }
                    }
                } else {
                    iTooltip.add((Component)Component.m_237115_((String)"agricraft.tooltip.magnifying.no_plant"));
                }
                if (crop.hasWeeds()) {
                    iTooltip.add((Component)Component.m_237115_((String)"agricraft.tooltip.magnifying.weeds").m_7220_(LangUtils.weedName(crop.getWeedId())));
                    if (blockAccessor.getPlayer().m_6144_()) {
                        iTooltip.add((Component)Component.m_237113_((String)"  ").m_7220_((Component)Component.m_237110_((String)"agricraft.tooltip.magnifying.growth", (Object[])new Object[]{crop.getWeedGrowthStage().index() + 1, crop.getWeedGrowthStage().total()})));
                    }
                }
            }
        }

        public ResourceLocation getUid() {
            return ID;
        }
    }

    public static class SoilComponentProvider
    implements IBlockComponentProvider {
        public static final SoilComponentProvider INSTANCE = new SoilComponentProvider();
        private static final ResourceLocation ID = new ResourceLocation("agricraft", "soil");

        private SoilComponentProvider() {
        }

        public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
            Optional<AgriSoil> soil = AgriApi.getSoil((BlockGetter)blockAccessor.getLevel(), blockAccessor.getPosition(), blockAccessor.getLevel().m_9598_());
            if (soil.isPresent() && blockAccessor.getPlayer().m_6144_()) {
                AgriSoil soil1 = soil.get();
                iTooltip.add((Component)Component.m_237115_((String)"agricraft.tooltip.magnifying.soil.humidity").m_7220_((Component)Component.m_237115_((String)("agricraft.soil.humidity." + soil1.humidity().name().toLowerCase()))));
                iTooltip.add((Component)Component.m_237115_((String)"agricraft.tooltip.magnifying.soil.acidity").m_7220_((Component)Component.m_237115_((String)("agricraft.soil.acidity." + soil1.acidity().name().toLowerCase()))));
                iTooltip.add((Component)Component.m_237115_((String)"agricraft.tooltip.magnifying.soil.nutrients").m_7220_((Component)Component.m_237115_((String)("agricraft.soil.nutrients." + soil1.nutrients().name().toLowerCase()))));
            }
        }

        public ResourceLocation getUid() {
            return ID;
        }
    }
}

