/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.datagen.provider.client.model;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.data.json.JSONHelper;
import it.zerono.mods.zerocore.lib.datagen.provider.client.model.FloatVector;
import it.zerono.mods.zerocore.lib.datagen.provider.client.model.UV;
import it.zerono.mods.zerocore.lib.functional.NonNullBiConsumer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraftforge.common.util.NonNullConsumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class ElementBuilder
implements Supplier<JsonElement> {
    private final Map<Direction, FaceBuilder> _faces = new Object2ObjectArrayMap(CodeHelper.DIRECTIONS.length);
    private FloatVector _from;
    private FloatVector _to;
    @Nullable
    private RotationBuilder _rotation;
    private boolean _shade = true;

    public ElementBuilder from(float x, float y, float z) {
        Preconditions.checkState((null == this._from ? 1 : 0) != 0, (Object)"The starting point of the cuboid is already defined for this element");
        this._from = ElementBuilder.cuboidVertex(x, y, z);
        return this;
    }

    public ElementBuilder to(float x, float y, float z) {
        Preconditions.checkState((null == this._to ? 1 : 0) != 0, (Object)"The ending point of the cuboid is already defined for this element");
        this._to = ElementBuilder.cuboidVertex(x, y, z);
        return this;
    }

    public ElementBuilder rotation(NonNullConsumer<RotationBuilder> builder) {
        Preconditions.checkNotNull(builder, (Object)"Builder cannot be null");
        Preconditions.checkState((null == this._rotation ? 1 : 0) != 0, (Object)"A rotation is already defined for this element");
        this._rotation = new RotationBuilder();
        builder.accept((Object)this._rotation);
        return this;
    }

    public ElementBuilder face(Direction face, NonNullConsumer<FaceBuilder> builder) {
        Preconditions.checkNotNull((Object)face, (Object)"Face cannot be null");
        Preconditions.checkNotNull(builder, (Object)"Builder cannot be null");
        Preconditions.checkState((!this._faces.containsKey(face) ? 1 : 0) != 0, (Object)"The specified face is already defined for this element");
        this._faces.put(face, (FaceBuilder)Util.m_137469_((Object)new FaceBuilder(), arg_0 -> builder.accept(arg_0)));
        return this;
    }

    public ElementBuilder faces(NonNullBiConsumer<Direction, FaceBuilder> builder) {
        return this.faces(builder, (List<Direction>)new ObjectArrayList((Object[])CodeHelper.DIRECTIONS));
    }

    public ElementBuilder faces(NonNullBiConsumer<Direction, FaceBuilder> builder, Direction ... ignored) {
        ObjectArrayList directions = new ObjectArrayList((Object[])CodeHelper.DIRECTIONS);
        if (ignored.length > 0) {
            directions.removeAll((Collection)new ObjectArrayList((Object[])ignored));
        }
        return this.faces(builder, (List<Direction>)directions);
    }

    public ElementBuilder shade(boolean shade) {
        this._shade = shade;
        return this;
    }

    @Override
    @ApiStatus.Internal
    public JsonElement get() {
        JsonObject json = new JsonObject();
        json.add("from", null != this._from ? this._from.get() : FloatVector.zero().get());
        json.add("to", null != this._to ? this._to.get() : FloatVector.of(16.0f, 16.0f, 16.0f).get());
        if (null != this._rotation) {
            json.add("rotation", this._rotation.get());
        }
        if (!this._shade) {
            json.addProperty("shade", Boolean.valueOf(false));
        }
        if (!this._faces.isEmpty()) {
            JsonObject faces = new JsonObject();
            this._faces.forEach((direction, face) -> faces.add(direction.m_7912_(), face.get()));
            json.add("faces", (JsonElement)faces);
        }
        return json;
    }

    private static FloatVector cuboidVertex(float x, float y, float z) {
        if (x < -16.0f || x > 32.0f) {
            throw new IllegalArgumentException("X must be between -16 and 32");
        }
        if (y < -16.0f || y > 32.0f) {
            throw new IllegalArgumentException("Y must be between -16 and 32");
        }
        if (z < -16.0f || z > 32.0f) {
            throw new IllegalArgumentException("Z must be between -16 and 32");
        }
        return FloatVector.of(x, y, z);
    }

    private ElementBuilder faces(NonNullBiConsumer<Direction, FaceBuilder> builder, List<Direction> directions) {
        Preconditions.checkNotNull(builder, (Object)"Builder cannot be null");
        Preconditions.checkState((boolean)this._faces.isEmpty(), (Object)"One or more faces are already defined for this element");
        for (Direction face : directions) {
            this._faces.put(face, (FaceBuilder)Util.m_137469_((Object)new FaceBuilder(), $ -> builder.accept(face, (FaceBuilder)$)));
        }
        return this;
    }

    public static class RotationBuilder
    implements Supplier<JsonElement> {
        private FloatVector _origin = FloatVector.zero();
        private Direction.Axis _axis = Direction.Axis.X;
        private float _angle;
        private boolean _rescale;

        RotationBuilder() {
        }

        public RotationBuilder origin(float x, float y, float z) {
            this._origin = FloatVector.of(x, y, z);
            return this;
        }

        public RotationBuilder axis(Direction.Axis axis) {
            Preconditions.checkNotNull((Object)axis, (Object)"Rotation axis cannot be null");
            this._axis = axis;
            return this;
        }

        public RotationBuilder angle(float angle) {
            Preconditions.checkArgument((0.0f == angle || 22.5f == Mth.m_14154_((float)angle) || 45.0f == Mth.m_14154_((float)angle) ? 1 : 0) != 0, (String)"Invalid rotation angle %f found. Allowed values are -45 / -22.5 / 0 / 22.5 / 45", (Object)Float.valueOf(angle));
            this._angle = angle;
            return this;
        }

        public RotationBuilder rescale(boolean rescale) {
            this._rescale = rescale;
            return this;
        }

        @Override
        @ApiStatus.Internal
        public JsonElement get() {
            JsonObject json = new JsonObject();
            json.add("origin", this._origin.get());
            json.addProperty("axis", this._axis.m_122477_());
            if (0.0f != this._angle) {
                json.addProperty("angle", (Number)Float.valueOf(this._angle));
            }
            if (this._rescale) {
                json.addProperty("rescale", Boolean.valueOf(true));
            }
            return json;
        }
    }

    public static class FaceBuilder
    implements Supplier<JsonElement> {
        @Nullable
        private UV _uv;
        private String _texture;
        private Direction _cullface;
        private int _rotation;
        private int _tintIndex = -1;

        FaceBuilder() {
        }

        public FaceBuilder uv(float u1, float v1, float u2, float v2) {
            Preconditions.checkState((null == this._uv ? 1 : 0) != 0, (Object)"UV is already defined for this face");
            this._uv = new UV(u1, v1, u2, v2);
            return this;
        }

        public FaceBuilder texture(String texture) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)texture) ? 1 : 0) != 0, (Object)"Texture cannot be null or an empty string");
            Preconditions.checkState((null == this._texture ? 1 : 0) != 0, (Object)"Texture is already defined for this face");
            this._texture = texture;
            return this;
        }

        public FaceBuilder cullface(Direction cullface) {
            Preconditions.checkNotNull((Object)cullface, (Object)"Cullface cannot be null");
            Preconditions.checkState((null == this._cullface ? 1 : 0) != 0, (Object)"The face to be culled is already defined for this face");
            this._cullface = cullface;
            return this;
        }

        public FaceBuilder rotation(int rotation) {
            Preconditions.checkArgument((0 == rotation || 90 == rotation || 180 == rotation || 270 == rotation ? 1 : 0) != 0, (Object)"Rotation can only be 0, 90, 180 or 270");
            this._rotation = rotation;
            return this;
        }

        public FaceBuilder tintIndex(int index) {
            this._tintIndex = index;
            return this;
        }

        @Override
        @ApiStatus.Internal
        public JsonElement get() {
            Preconditions.checkState((null != this._texture ? 1 : 0) != 0, (Object)"A texture was not defined for this face");
            JsonObject json = new JsonObject();
            if (null != this._uv) {
                json.add("uv", this._uv.get());
            }
            json.addProperty("texture", JSONHelper.serializeTextureName(this._texture));
            if (null != this._cullface) {
                json.addProperty("cullface", this._cullface.m_7912_());
            }
            if (0 != this._rotation) {
                json.addProperty("rotation", (Number)this._rotation);
            }
            if (-1 != this._tintIndex) {
                json.addProperty("tintindex", (Number)this._tintIndex);
            }
            return json;
        }
    }
}

