/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasscodeConvertible;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blockentities.KeypadBlockEntity;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.blocks.FrameBlock;
import net.geforcemods.securitycraft.misc.SaltData;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class KeypadBlock
extends DisguisableBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    public KeypadBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        KeypadBlockEntity be = (KeypadBlockEntity)level.m_7702_(pos);
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue() && be.getSignalLength() > 0) {
            return InteractionResult.PASS;
        }
        if (!level.f_46443_) {
            if (be.isDisabled()) {
                player.m_5661_((Component)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
            } else if (be.verifyPasscodeSet(level, pos, be, player)) {
                if (be.isDenied((Entity)player)) {
                    if (be.sendsDenylistMessage()) {
                        PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.m_7705_(), new Object[0]), Utils.localize("messages.securitycraft:module.onDenylist", new Object[0]), ChatFormatting.RED);
                    }
                } else if (be.isAllowed((Entity)player)) {
                    if (be.sendsAllowlistMessage()) {
                        PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.m_7705_(), new Object[0]), Utils.localize("messages.securitycraft:module.onAllowlist", new Object[0]), ChatFormatting.GREEN);
                    }
                    this.activate(state, level, pos, be.getSignalLength());
                } else if (!player.m_21120_(hand).m_150930_((Item)SCContent.CODEBREAKER.get())) {
                    be.openPasscodeGUI(level, pos, player);
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void activate(BlockState state, Level level, BlockPos pos, int signalLength) {
        level.m_46597_(pos, (BlockState)state.m_61122_((Property)POWERED));
        BlockUtils.updateIndirectNeighbors(level, pos, (Block)SCContent.KEYPAD.get());
        if (signalLength > 0) {
            level.m_186460_(pos, (Block)this, signalLength);
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
            BlockUtils.updateIndirectNeighbors((Level)level, pos, (Block)SCContent.KEYPAD.get());
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity;
            if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
                BlockUtils.updateIndirectNeighbors(level, pos, (Block)this);
            }
            if ((blockEntity = level.m_7702_(pos)) instanceof IPasscodeProtected) {
                IPasscodeProtected be = (IPasscodeProtected)blockEntity;
                SaltData.removeSalt(be.getSaltKey());
            }
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public boolean shouldCheckWeakPower(BlockState state, SignalGetter level, BlockPos pos, Direction side) {
        return false;
    }

    public int m_6378_(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        return (Boolean)state.m_61143_((Property)POWERED) != false ? 15 : 0;
    }

    public int m_6376_(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        return (Boolean)state.m_61143_((Property)POWERED) != false ? 15 : 0;
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)super.m_5573_(ctx).m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_())).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false));
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return ItemStack.f_41583_;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, POWERED, WATERLOGGED});
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new KeypadBlockEntity(pos, state);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public static class Convertible
    implements IPasscodeConvertible {
        @Override
        public boolean isUnprotectedBlock(BlockState state) {
            return state.m_60713_((Block)SCContent.FRAME.get());
        }

        @Override
        public boolean isProtectedBlock(BlockState state) {
            return state.m_60713_((Block)SCContent.KEYPAD.get());
        }

        @Override
        public boolean protect(Player player, Level level, BlockPos pos) {
            Owner owner = ((IOwnable)level.m_7702_(pos)).getOwner();
            level.m_46597_(pos, (BlockState)((BlockState)((Block)SCContent.KEYPAD.get()).m_49966_().m_61124_((Property)FACING, (Comparable)((Direction)level.m_8055_(pos).m_61143_((Property)FrameBlock.FACING)))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
            ((IOwnable)level.m_7702_(pos)).setOwner(owner.getUUID(), owner.getName());
            return true;
        }

        @Override
        public boolean unprotect(Player player, Level level, BlockPos pos) {
            Owner owner = ((IOwnable)level.m_7702_(pos)).getOwner();
            ((IModuleInventory)level.m_7702_(pos)).dropAllModules();
            level.m_46597_(pos, (BlockState)((Block)SCContent.FRAME.get()).m_49966_().m_61124_((Property)FrameBlock.FACING, (Comparable)((Direction)level.m_8055_(pos).m_61143_((Property)FACING))));
            ((IOwnable)level.m_7702_(pos)).setOwner(owner.getUUID(), owner.getName());
            return true;
        }
    }
}

