/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.client;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.entity.camera.CameraController;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.geforcemods.securitycraft.misc.OverlayToggleHandler;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.network.NetworkEvent;

public class SetCameraView {
    private int id;

    public SetCameraView() {
    }

    public SetCameraView(Entity camera) {
        this.id = camera.m_19879_();
    }

    public SetCameraView(FriendlyByteBuf buf) {
        this.id = buf.m_130242_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130130_(this.id);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        Minecraft mc = Minecraft.m_91087_();
        Entity entity = mc.f_91073_.m_6815_(this.id);
        boolean isMountingCamera = entity instanceof SecurityCamera;
        if (isMountingCamera || entity instanceof Player) {
            mc.m_91118_(entity);
            if (isMountingCamera) {
                CameraController.previousCameraType = mc.f_91066_.m_92176_();
                mc.f_91066_.m_92157_(CameraType.FIRST_PERSON);
                mc.f_91065_.m_93063_((Component)Utils.localize("mount.onboard", mc.f_91066_.f_92090_.m_90863_()), false);
                CameraController.setRenderPosition(entity);
                OverlayToggleHandler.disable(VanillaGuiOverlay.EXPERIENCE_BAR);
                OverlayToggleHandler.disable(VanillaGuiOverlay.JUMP_BAR);
                OverlayToggleHandler.disable(VanillaGuiOverlay.POTION_ICONS);
                OverlayToggleHandler.enable(ClientHandler.cameraOverlay);
            } else {
                if (CameraController.previousCameraType != null) {
                    mc.f_91066_.m_92157_(CameraController.previousCameraType);
                }
                CameraController.resetOverlaysAfterDismount = true;
            }
            mc.f_91060_.m_109818_();
        }
    }
}

