/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.datagen.provider.client.state;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.zerono.mods.zerocore.lib.datagen.provider.client.model.ModelBuilder;
import it.zerono.mods.zerocore.lib.datagen.provider.client.state.ModelVariantBuilder;
import it.zerono.mods.zerocore.lib.datagen.provider.client.state.ModelVariantsList;
import net.minecraft.Util;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.util.NonNullConsumer;

public class SingleVariantBuilder
implements BlockStateGenerator {
    private final ModelBuilder _modelBuilder;
    private final Block _block;
    private final ModelVariantsList _modelVariants;

    SingleVariantBuilder(ModelBuilder modelBuilder, Block block) {
        Preconditions.checkNotNull((Object)modelBuilder, (Object)"Model builder must not be null");
        Preconditions.checkNotNull((Object)block, (Object)"Block must not be null");
        this._modelBuilder = modelBuilder;
        this._block = block;
        this._modelVariants = new ModelVariantsList(8);
    }

    public void model(ResourceLocation model) {
        Preconditions.checkNotNull((Object)model, (Object)"Model must not be null");
        this._modelVariants.add(Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)model));
    }

    public void variant(Variant ... variants) {
        Preconditions.checkArgument((variants.length > 0 ? 1 : 0) != 0, (Object)"At least one model variant must be provided");
        this._modelVariants.add(variants);
    }

    public void variant(NonNullConsumer<ModelVariantBuilder> builder) {
        Preconditions.checkNotNull(builder, (Object)"Variant builder must not be null");
        ModelVariantBuilder.build(this._modelVariants, this._modelBuilder, builder);
    }

    public Block m_6968_() {
        return this._block;
    }

    public JsonElement get() {
        return (JsonElement)Util.m_137469_((Object)new JsonObject(), json -> json.add("variants", (JsonElement)this._modelVariants.apply("", new JsonObject())));
    }
}

