/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.networking;

import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public abstract class BlockEntityDataPacket<BE extends SyncedBlockEntity>
extends SimplePacketBase {
    protected BlockPos pos;

    public BlockEntityDataPacket(FriendlyByteBuf buffer) {
        this.pos = buffer.m_130135_();
    }

    public BlockEntityDataPacket(BlockPos pos) {
        this.pos = pos;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        this.writeData(buffer);
    }

    @Override
    public boolean handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            if (world == null) {
                return;
            }
            BlockEntity blockEntity = world.m_7702_(this.pos);
            if (blockEntity instanceof SyncedBlockEntity) {
                this.handlePacket((SyncedBlockEntity)blockEntity);
            }
        });
        return true;
    }

    protected abstract void writeData(FriendlyByteBuf var1);

    protected abstract void handlePacket(BE var1);
}

