/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.api.adapter;

import com.agricraft.agricraft.api.AgriApi;
import com.agricraft.agricraft.api.adapter.AgriAdapter;
import com.agricraft.agricraft.api.genetic.AgriGenome;
import java.util.Optional;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class GenomeAdapter
implements AgriAdapter<AgriGenome> {
    @Override
    public boolean accepts(Object obj) {
        if (obj instanceof ItemLike) {
            ItemLike itemLike = (ItemLike)obj;
            return this.accepts(new ItemStack(itemLike));
        }
        if (obj instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)obj;
            return this.match(itemStack);
        }
        return false;
    }

    @Override
    public Optional<AgriGenome> valueOf(Object obj) {
        if (obj instanceof ItemLike) {
            ItemLike itemLike = (ItemLike)obj;
            return this.valueOf(new ItemStack(itemLike));
        }
        if (obj instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)obj;
            return this.convert(itemStack);
        }
        return Optional.empty();
    }

    public boolean match(ItemStack itemStack) {
        return AgriApi.getPlantRegistry().map(registry -> registry.m_123024_().anyMatch(seed -> seed.isSeedItem(itemStack))).orElse(false);
    }

    public Optional<AgriGenome> convert(ItemStack itemStack) {
        return AgriApi.getPlantRegistry().flatMap(registry -> registry.m_123024_().filter(plant -> plant.isSeedItem(itemStack)).findFirst().map(AgriGenome::new));
    }
}

