/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.common.commands;

import com.agricraft.agricraft.api.AgriApi;
import com.agricraft.agricraft.api.genetic.AgriAllele;
import com.agricraft.agricraft.api.genetic.AgriGene;
import com.agricraft.agricraft.api.genetic.AgriGenePair;
import com.agricraft.agricraft.api.genetic.AgriGeneRegistry;
import com.agricraft.agricraft.api.genetic.AgriGenome;
import com.agricraft.agricraft.api.plant.AgriPlant;
import com.agricraft.agricraft.api.stat.AgriStat;
import com.agricraft.agricraft.api.stat.AgriStatRegistry;
import com.agricraft.agricraft.common.item.AgriSeedItem;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;

public class GiveSeedCommand {
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_PLANTS = (commandContext, suggestionsBuilder) -> SharedSuggestionProvider.m_82926_((Iterable)AgriApi.getPlantRegistry(((CommandSourceStack)commandContext.getSource()).m_5894_()).map(Registry::m_6566_).orElse(Set.of()), (SuggestionsBuilder)suggestionsBuilder);

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"agricraft_seed").requires(commandSourceStack -> commandSourceStack.m_6761_(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"plant", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_PLANTS).executes(commandContext -> GiveSeedCommand.giveSeed((CommandSourceStack)commandContext.getSource(), ResourceLocationArgument.m_107011_((CommandContext)commandContext, (String)"plant")))).then(Commands.m_82127_((String)"all").then(Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1, (int)10)).executes(commandContext -> GiveSeedCommand.giveSeed((CommandSourceStack)commandContext.getSource(), ResourceLocationArgument.m_107011_((CommandContext)commandContext, (String)"plant"), IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"count")))))).then(Commands.m_82127_((String)"distinct").then(Commands.m_82129_((String)"value", (ArgumentType)StringArgumentType.string()).executes(commandContext -> GiveSeedCommand.giveSeed((CommandSourceStack)commandContext.getSource(), ResourceLocationArgument.m_107011_((CommandContext)commandContext, (String)"plant"), StringArgumentType.getString((CommandContext)commandContext, (String)"value")))))));
    }

    public static int giveSeed(CommandSourceStack source, ResourceLocation plant) {
        Optional<AgriPlant> optional = AgriApi.getPlant(plant, source.m_81372_().m_9598_());
        if (optional.isEmpty()) {
            return 0;
        }
        ItemStack itemStack = AgriSeedItem.toStack(optional.get());
        if (GiveSeedCommand.giveItemStack(itemStack, source.m_230896_(), source.m_81372_())) {
            source.m_288197_(() -> Component.m_237110_((String)"agricraft.command.seed_default", (Object[])new Object[]{plant}), true);
            return 1;
        }
        return 0;
    }

    public static int giveSeed(CommandSourceStack source, ResourceLocation plant, int value) {
        AgriAllele<String> allele = AgriGeneRegistry.getInstance().getGeneSpecies().getAllele(plant.toString());
        AgriGenome genome = new AgriGenome(new AgriGenePair<String>(AgriGeneRegistry.getInstance().getGeneSpecies(), allele), AgriStatRegistry.getInstance().stream().sorted(Comparator.comparing(AgriStat::getId)).map(stat -> AgriGeneRegistry.getInstance().getGeneStat((AgriStat)stat)).filter(Optional::isPresent).map(Optional::get).map(gene -> new AgriGenePair<Integer>((AgriGene<Integer>)gene, gene.getAllele(value))).toList());
        ItemStack itemStack = AgriSeedItem.toStack(genome);
        if (GiveSeedCommand.giveItemStack(itemStack, source.m_230896_(), source.m_81372_())) {
            source.m_288197_(() -> Component.m_237110_((String)"agricraft.command.seed_all", (Object[])new Object[]{plant, value}), true);
            return 1;
        }
        return 0;
    }

    private static int giveSeed(CommandSourceStack source, ResourceLocation plant, String distincts) {
        int i;
        AgriAllele<String> allele = AgriGeneRegistry.getInstance().getGeneSpecies().getAllele(plant.toString());
        List<AgriGene> genes = AgriStatRegistry.getInstance().stream().sorted(Comparator.comparing(AgriStat::getId)).map(stat -> AgriGeneRegistry.getInstance().getGeneStat((AgriStat)stat)).filter(Optional::isPresent).map(Optional::get).toList();
        ArrayList<AgriGenePair<Integer>> genePairs = new ArrayList<AgriGenePair<Integer>>();
        String[] split = distincts.split("-");
        int[] values = new int[AgriStatRegistry.getInstance().size()];
        Arrays.fill(values, 1);
        for (i = 0; i < split.length; ++i) {
            String s = split[i];
            try {
                values[i] = Mth.m_14045_((int)Integer.parseInt(s), (int)1, (int)10);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        for (i = 0; i < genes.size() && i < values.length; ++i) {
            AgriGene gene = genes.get(i);
            genePairs.add(new AgriGenePair<Integer>(gene, gene.getAllele(values[i])));
        }
        AgriGenome genome = new AgriGenome(new AgriGenePair<String>(AgriGeneRegistry.getInstance().getGeneSpecies(), allele), genePairs);
        ItemStack itemStack = AgriSeedItem.toStack(genome);
        if (GiveSeedCommand.giveItemStack(itemStack, source.m_230896_(), source.m_81372_())) {
            source.m_288197_(() -> Component.m_237110_((String)"agricraft.command.seed_distinct", (Object[])new Object[]{plant, distincts}), true);
            return 1;
        }
        return 0;
    }

    private static boolean giveItemStack(ItemStack itemStack, ServerPlayer player, ServerLevel level) {
        boolean added = player.m_150109_().m_36054_(itemStack);
        if (!added || !itemStack.m_41619_()) {
            ItemEntity itemEntity = player.m_36176_(itemStack, false);
            if (itemEntity == null) {
                return false;
            }
            itemEntity.m_32061_();
            itemEntity.m_266426_(player.m_20148_());
        }
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((player.m_217043_().m_188501_() - player.m_217043_().m_188501_()) * 0.7f + 1.0f) * 2.0f);
        player.f_36096_.m_38946_();
        return true;
    }
}

