/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.common.item;

import com.agricraft.agricraft.api.AgriApi;
import com.agricraft.agricraft.api.config.CoreConfig;
import com.agricraft.agricraft.api.crop.AgriCrop;
import com.agricraft.agricraft.api.genetic.AgriGenome;
import com.agricraft.agricraft.api.genetic.AgriGenomeProviderItem;
import com.agricraft.agricraft.api.stat.AgriStat;
import com.agricraft.agricraft.api.stat.AgriStatRegistry;
import com.agricraft.agricraft.common.block.CropBlock;
import com.agricraft.agricraft.common.block.CropState;
import com.agricraft.agricraft.common.item.AgriSeedItem;
import com.agricraft.agricraft.common.registry.ModBlocks;
import com.agricraft.agricraft.common.util.LangUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class SeedBagItem
extends Item {
    public static final List<BagSorter> SORTERS = new ArrayList<BagSorter>();
    public static final BagSorter DEFAULT_SORTER = new BagSorter(){

        @Override
        public ResourceLocation getId() {
            return new ResourceLocation("agricraft", "default");
        }

        @Override
        public int compare(BagEntry entry1, BagEntry entry2) {
            int s2;
            int s1 = AgriStatRegistry.getInstance().stream().mapToInt(stat -> entry1.genome.getStatGene((AgriStat)stat).getTrait()).sum();
            if (s1 != (s2 = AgriStatRegistry.getInstance().stream().mapToInt(stat -> entry2.genome.getStatGene((AgriStat)stat).getTrait()).sum())) {
                return s2 - s1;
            }
            return AgriStatRegistry.getInstance().stream().mapToInt(stat -> {
                Integer d1 = entry1.genome.getStatGene((AgriStat)stat).getDominant().trait();
                Integer r1 = entry1.genome.getStatGene((AgriStat)stat).getRecessive().trait();
                Integer d2 = entry2.genome.getStatGene((AgriStat)stat).getDominant().trait();
                Integer r2 = entry2.genome.getStatGene((AgriStat)stat).getRecessive().trait();
                return d2 + r2 - (d1 + r1);
            }).sum();
        }
    };

    public SeedBagItem(Item.Properties properties) {
        super(properties);
    }

    public static void addStatSorter(AgriStat stat) {
        SORTERS.add(new StatSorter(stat));
    }

    private static boolean plantOnCrop(AgriCrop crop, ItemStack seed) {
        if (crop.hasPlant() || crop.isCrossCropSticks()) {
            return false;
        }
        crop.plantGenome(AgriGenome.fromNBT(seed.m_41783_()));
        return true;
    }

    public static int add(ItemStack seedBag, ItemStack insertedStack) {
        Item item;
        if (insertedStack.m_41619_() || !((item = insertedStack.m_41720_()) instanceof AgriGenomeProviderItem)) {
            return 0;
        }
        AgriGenomeProviderItem seed = (AgriGenomeProviderItem)item;
        CompoundTag tag = seedBag.m_41784_();
        Optional<AgriGenome> opt = seed.getGenome(insertedStack);
        if (opt.isEmpty()) {
            return 0;
        }
        AgriGenome genome = opt.get();
        if (tag.m_128441_("species") && !genome.getSpeciesGene().getTrait().equals(tag.m_128461_("species"))) {
            return 0;
        }
        if (!tag.m_128441_("seeds")) {
            tag.m_128365_("seeds", (Tag)new ListTag());
            tag.m_128359_("species", genome.getSpeciesGene().getTrait());
        }
        ListTag seeds = tag.m_128437_("seeds", 10);
        int size = SeedBagItem.size(seedBag);
        if (size >= CoreConfig.seedBagCapacity) {
            return 0;
        }
        CompoundTag seedTag = new CompoundTag();
        int insertedCount = Math.min(CoreConfig.seedBagCapacity - size, insertedStack.m_41613_());
        seedTag.m_128405_("count", insertedCount);
        genome.writeToNBT(seedTag);
        seeds.add((Object)seedTag);
        SeedBagItem.sort(seedBag);
        return insertedCount;
    }

    public static ItemStack extractFirstStack(ItemStack seedBag) {
        ListTag seeds = seedBag.m_41783_().m_128437_("seeds", 10);
        BagEntry entry = BagEntry.fromNBT(seeds.m_128728_(0));
        ItemStack seed = AgriSeedItem.toStack(entry.genome);
        seed.m_41764_(entry.count);
        seeds.remove(0);
        if (seeds.isEmpty()) {
            seedBag.m_41783_().m_128473_("seeds");
            seedBag.m_41783_().m_128473_("species");
        }
        return seed;
    }

    public static ItemStack extractFirstItem(ItemStack seedBag, boolean simulate) {
        ListTag seeds = seedBag.m_41783_().m_128437_("seeds", 10);
        CompoundTag seedTag = seeds.m_128728_(0);
        AgriGenome genome = AgriGenome.fromNBT(seedTag);
        ItemStack seed = AgriSeedItem.toStack(genome);
        if (!simulate) {
            int count = seedTag.m_128451_("count") - 1;
            seedTag.m_128405_("count", count);
            if (count <= 0) {
                seeds.remove(0);
            }
            if (seeds.isEmpty()) {
                seedBag.m_41783_().m_128473_("seeds");
                seedBag.m_41783_().m_128473_("species");
            }
        }
        return seed;
    }

    public static void changeSorter(ItemStack seedBag, int delta) {
        if (delta == 0) {
            return;
        }
        CompoundTag tag = seedBag.m_41784_();
        int sorterIndex = 0;
        if (tag.m_128441_("sorter")) {
            sorterIndex = tag.m_128451_("sorter");
        }
        if ((sorterIndex += delta) < 0) {
            sorterIndex += SORTERS.size();
        }
        tag.m_128405_("sorter", sorterIndex %= SORTERS.size());
        SeedBagItem.sort(seedBag);
    }

    private static void sort(ItemStack seedBag) {
        CompoundTag tag = seedBag.m_41784_();
        int sorterIndex = 0;
        if (tag.m_128441_("sorter")) {
            sorterIndex = tag.m_128451_("sorter");
        }
        ListTag listTag = tag.m_128437_("seeds", 10);
        ArrayList<BagEntry> entries = new ArrayList<BagEntry>();
        for (int i = 0; i < listTag.size(); ++i) {
            entries.add(BagEntry.fromNBT(listTag.m_128728_(i)));
        }
        BagSorter sorter = SORTERS.get(sorterIndex);
        entries.sort(sorter);
        listTag.clear();
        for (BagEntry entry : entries) {
            CompoundTag t = new CompoundTag();
            entry.writeToNBT(t);
            listTag.add((Object)t);
        }
    }

    public static int size(ItemStack seedBag) {
        CompoundTag tag = seedBag.m_41783_();
        if (tag == null || !tag.m_128441_("seeds")) {
            return 0;
        }
        ListTag seeds = tag.m_128437_("seeds", 10);
        int count = 0;
        for (int i = 0; i < seeds.size(); ++i) {
            count += seeds.m_128728_(i).m_128451_("count");
        }
        return count;
    }

    public static boolean isEmpty(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag == null || !tag.m_128441_("species");
    }

    public static boolean isFilled(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128441_("seeds") && SeedBagItem.size(stack) == CoreConfig.seedBagCapacity;
    }

    private static void playRemoveOneSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184216_, 0.8f, 0.8f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    private static void playInsertSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184215_, 0.8f, 0.8f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43724_() == InteractionHand.OFF_HAND) {
            return super.m_6225_(context);
        }
        ItemStack seedBag = context.m_43722_();
        if (SeedBagItem.isEmpty(seedBag)) {
            return InteractionResult.PASS;
        }
        Level level = context.m_43725_();
        ItemStack seed = SeedBagItem.extractFirstItem(seedBag, true);
        BlockPos pos = context.m_8083_();
        Optional<AgriCrop> optional = AgriApi.getCrop((BlockGetter)level, pos);
        if (optional.isPresent()) {
            if (SeedBagItem.plantOnCrop(optional.get(), seed)) {
                SeedBagItem.extractFirstItem(seedBag, false);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        optional = AgriApi.getCrop((BlockGetter)level, pos.m_7494_());
        if (optional.isPresent()) {
            if (SeedBagItem.plantOnCrop(optional.get(), seed)) {
                SeedBagItem.extractFirstItem(seedBag, false);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        if (CoreConfig.plantOffCropSticks && AgriApi.getSoil(level, pos).isPresent() && level.m_8055_(pos.m_7494_()).m_60795_()) {
            level.m_7731_(pos.m_7494_(), (BlockState)((Block)ModBlocks.CROP.get()).m_49966_().m_61124_(CropBlock.CROP_STATE, (Comparable)((Object)CropState.PLANT)), 11);
            optional = AgriApi.getCrop((BlockGetter)level, pos.m_7494_());
            if (optional.isPresent()) {
                optional.get().plantGenome(AgriGenome.fromNBT(seed.m_41783_()), (LivingEntity)context.m_43723_());
                SeedBagItem.extractFirstItem(seedBag, false);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    public boolean m_142207_(ItemStack seedBag, Slot slot, ClickAction action, Player player) {
        if (seedBag.m_41613_() == 1 && action == ClickAction.SECONDARY) {
            ItemStack itemStack = slot.m_7993_();
            if (itemStack.m_41619_()) {
                if (!SeedBagItem.isEmpty(seedBag)) {
                    SeedBagItem.playRemoveOneSound((Entity)player);
                    ItemStack seed = SeedBagItem.extractFirstStack(seedBag);
                    slot.m_150659_(seed);
                }
            } else if (itemStack.m_41720_().m_142095_()) {
                int inserted = SeedBagItem.add(seedBag, itemStack);
                slot.m_150647_(itemStack.m_41613_(), inserted, player);
                if (inserted > 0) {
                    SeedBagItem.playInsertSound((Entity)player);
                }
            }
            return true;
        }
        return false;
    }

    public boolean m_142305_(ItemStack seedBag, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (seedBag.m_41613_() == 1 && action == ClickAction.SECONDARY && slot.m_150651_(player)) {
            int inserted;
            if (other.m_41619_()) {
                if (!SeedBagItem.isEmpty(seedBag)) {
                    SeedBagItem.playRemoveOneSound((Entity)player);
                    ItemStack seed = SeedBagItem.extractFirstStack(seedBag);
                    access.m_142104_(seed);
                }
            } else if (other.m_41720_().m_142095_() && (inserted = SeedBagItem.add(seedBag, other)) > 0) {
                SeedBagItem.playInsertSound((Entity)player);
                other.m_41774_(inserted);
            }
            return true;
        }
        return false;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        if (SeedBagItem.isEmpty(stack)) {
            tooltipComponents.add((Component)Component.m_237115_((String)"agricraft.tooltip.bag.empty").m_130940_(ChatFormatting.DARK_GRAY));
        } else {
            tooltipComponents.add((Component)Component.m_237110_((String)"agricraft.tooltip.bag.content", (Object[])new Object[]{SeedBagItem.size(stack)}).m_7220_(LangUtils.seedName(stack.m_41783_().m_128461_("species"))).m_130940_(ChatFormatting.DARK_GRAY));
        }
        int i = stack.m_41784_().m_128451_("sorter");
        String id = SORTERS.get(i).getId().toString().replace(":", ".");
        tooltipComponents.add((Component)Component.m_237115_((String)"agricraft.tooltip.bag.sorter").m_7220_((Component)Component.m_237115_((String)("agricraft.tooltip.bag.sorter." + id))).m_130940_(ChatFormatting.DARK_GRAY));
    }

    static {
        SORTERS.add(DEFAULT_SORTER);
    }

    public static class StatSorter
    implements BagSorter {
        private final AgriStat stat;
        private final ResourceLocation id;

        public StatSorter(AgriStat stat) {
            this.stat = stat;
            this.id = new ResourceLocation("agricraft", stat.getId());
        }

        @Override
        public ResourceLocation getId() {
            return this.id;
        }

        @Override
        public int compare(BagEntry entry1, BagEntry entry2) {
            int s2;
            int s1 = entry1.genome.getStatGene(this.stat).getTrait();
            if (s1 == (s2 = entry2.genome.getStatGene(this.stat).getTrait().intValue())) {
                return DEFAULT_SORTER.compare(entry1, entry2);
            }
            return s2 - s1;
        }
    }

    public record BagEntry(int count, AgriGenome genome) {
        public static BagEntry fromNBT(CompoundTag tag) {
            return new BagEntry(tag.m_128451_("count"), AgriGenome.fromNBT(tag));
        }

        public void writeToNBT(CompoundTag tag) {
            tag.m_128405_("count", this.count);
            this.genome.writeToNBT(tag);
        }
    }

    public static interface BagSorter
    extends Comparator<BagEntry> {
        public ResourceLocation getId();
    }
}

