/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.compat.emi;

import com.agricraft.agricraft.api.AgriApi;
import com.agricraft.agricraft.api.AgriClientApi;
import com.agricraft.agricraft.api.codecs.AgriSoilCondition;
import com.agricraft.agricraft.api.crop.AgriGrowthStage;
import com.agricraft.agricraft.api.plant.AgriPlant;
import com.agricraft.agricraft.api.requirement.AgriGrowthConditionRegistry;
import com.agricraft.agricraft.api.requirement.AgriSeason;
import com.agricraft.agricraft.common.item.AgriSeedItem;
import com.agricraft.agricraft.common.util.LangUtils;
import com.agricraft.agricraft.common.util.Platform;
import com.agricraft.agricraft.compat.emi.AgriCraftEmiPlugin;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.ButtonWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class CropRequirementRecipe
implements EmiRecipe {
    public static final EmiTexture BACKGROUND = new EmiTexture(new ResourceLocation("agricraft", "textures/gui/jei/crop_requirement.png"), 0, 0, 128, 128, 128, 128, 128, 128);
    public static final EmiTexture COMPONENTS = new EmiTexture(new ResourceLocation("agricraft", "textures/gui/jei/crop_requirement.png"), 0, 0, 128, 128, 128, 128, 128, 128);
    public static final EmiTexture GUI_COMPONENTS = new EmiTexture(new ResourceLocation("agricraft", "textures/gui/jei/crop_requirement_components.png"), 0, 0, 128, 128, 128, 128, 128, 128);
    public static final ResourceLocation R_COMPONENTS = new ResourceLocation("agricraft", "textures/gui/jei/crop_requirement_components.png");
    public static final ResourceLocation R_GUI_COMPONENTS = new ResourceLocation("agricraft", "textures/gui/gui_components.png");
    public static final int[] HUMIDITY_OFFSETS = new int[]{8, 8, 10, 10, 10, 7};
    public static final int[] ACIDITY_OFFSETS = new int[]{7, 8, 7, 8, 8, 8, 6};
    public static final int[] NUTRIENTS_OFFSETS = new int[]{6, 8, 9, 9, 11, 10};
    private final ResourceLocation id;
    private final List<EmiIngredient> input;
    private final AgriPlant plant;
    private final List<EmiStack> output;
    private final String plantId;
    public final Btn incStrButton;
    public final Btn decStrButton;
    public final Btn incStageButton;
    public final Btn decStageButton;
    private int currentStrength = AgriApi.getStatRegistry().strengthStat().getMin();
    private AgriGrowthStage currentStage;
    private List<Block> soils;
    private int soil;
    public long lastTime;

    public CropRequirementRecipe(ResourceLocation id, AgriPlant plant) {
        this.id = id;
        this.input = List.of(EmiStack.of((ItemStack)AgriSeedItem.toStack(plant)).comparison(AgriCraftEmiPlugin.compareSeeds()));
        this.plant = plant;
        this.output = new ArrayList<EmiStack>();
        this.plantId = AgriApi.getPlantId(plant).map(ResourceLocation::toString).orElse("");
        this.currentStage = plant.getInitialGrowthStage();
        this.incStrButton = new Btn(104, 10, 9, 9, this::incrementStrength, true);
        this.decStrButton = new Btn(104, 71, 9, 9, this::decrementStrength, false);
        this.incStageButton = new Btn(92, 10, 9, 9, this::incrementStage, true);
        this.decStageButton = new Btn(92, 71, 9, 9, this::decrementStage, false);
        this.updateSoils();
        this.lastTime = System.currentTimeMillis();
    }

    public EmiRecipeCategory getCategory() {
        return AgriCraftEmiPlugin.REQUIREMENT_CATEGORY;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.input;
    }

    public List<EmiStack> getOutputs() {
        return this.output;
    }

    public int getDisplayWidth() {
        return 128;
    }

    public int getDisplayHeight() {
        return 128;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(BACKGROUND, 0, 0);
        widgets.addSlot(this.input.get(0), 55, 2).drawBack(false);
        widgets.add((Widget)this.incStrButton);
        widgets.add((Widget)this.decStrButton);
        widgets.add((Widget)this.incStageButton);
        widgets.add((Widget)this.decStageButton);
        widgets.addDrawable(0, 0, 128, 128, (guiGraphics, mouseX, mouseY, partialTick) -> {
            long l;
            int i;
            int offset;
            int index;
            for (int i2 = 0; i2 < this.currentStrength; ++i2) {
                guiGraphics.m_280163_(R_COMPONENTS, 105, 66 - i2 * 5, 0.0f, 66.0f, 7, 3, 128, 128);
            }
            int maxHeight = 48;
            int stageHeight = (int)((double)maxHeight * this.currentStage.growthPercentage());
            int stageY = 21 + maxHeight - stageHeight;
            guiGraphics.m_280411_(R_COMPONENTS, 93, stageY, 7, stageHeight, 0.0f, 69.0f, 7, 1, 128, 128);
            for (int i3 = 15; i3 >= 0; --i3) {
                boolean fertile = AgriGrowthConditionRegistry.getLight().apply(this.plant, this.currentStrength, i3).isFertile();
                if (!fertile) continue;
                guiGraphics.m_280411_(R_COMPONENTS, 32, 26 + 3 * (15 - i3), 3, 3, 0.0f, (float)(18 + 3 * (15 - i3)), 3, 3, 128, 128);
            }
            for (AgriSoilCondition.Humidity humidity : AgriSoilCondition.Humidity.values()) {
                if (!humidity.isValid() || !AgriGrowthConditionRegistry.getHumidity().apply(this.plant, this.currentStrength, humidity).isFertile()) continue;
                index = humidity.ordinal();
                offset = 0;
                for (i = 0; i < index; ++i) {
                    offset += HUMIDITY_OFFSETS[i];
                }
                guiGraphics.m_280411_(R_GUI_COMPONENTS, 37 + offset, 83, HUMIDITY_OFFSETS[index], 12, (float)offset, 0.0f, HUMIDITY_OFFSETS[index], 12, 128, 128);
            }
            for (Enum enum_ : AgriSoilCondition.Acidity.values()) {
                if (!((AgriSoilCondition.Acidity)enum_).isValid() || !AgriGrowthConditionRegistry.getAcidity().apply(this.plant, this.currentStrength, (AgriSoilCondition.Acidity)enum_).isFertile()) continue;
                index = enum_.ordinal();
                offset = 0;
                for (i = 0; i < index; ++i) {
                    offset += ACIDITY_OFFSETS[i];
                }
                guiGraphics.m_280411_(R_GUI_COMPONENTS, 37 + offset, 96, ACIDITY_OFFSETS[index], 12, (float)offset, 12.0f, ACIDITY_OFFSETS[index], 12, 128, 128);
            }
            for (Enum enum_ : AgriSoilCondition.Nutrients.values()) {
                if (!((AgriSoilCondition.Nutrients)enum_).isValid() || !AgriGrowthConditionRegistry.getNutrients().apply(this.plant, this.currentStrength, (AgriSoilCondition.Nutrients)enum_).isFertile()) continue;
                index = enum_.ordinal();
                offset = 0;
                for (i = 0; i < index; ++i) {
                    offset += NUTRIENTS_OFFSETS[i];
                }
                guiGraphics.m_280411_(R_GUI_COMPONENTS, 37 + offset, 109, NUTRIENTS_OFFSETS[index], 12, (float)offset, 24.0f, NUTRIENTS_OFFSETS[index], 12, 128, 128);
            }
            if (AgriApi.getSeasonLogic().isActive()) {
                for (Enum enum_ : AgriSeason.values()) {
                    if (enum_ == AgriSeason.ANY || !AgriGrowthConditionRegistry.getSeason().apply(this.plant, this.currentStrength, (AgriSeason)enum_).isFertile()) continue;
                    guiGraphics.m_280163_(R_GUI_COMPONENTS, 17, 24 + 13 * enum_.ordinal(), (float)(10 * enum_.ordinal()), 44.0f, 10, 12, 128, 128);
                }
            }
            if (this.lastTime + 1500L <= (l = System.currentTimeMillis()) && !Screen.m_96638_()) {
                ++this.soil;
                if (this.soil >= this.soils.size()) {
                    this.soil = 0;
                }
                this.lastTime = l;
            }
            PoseStack stack = guiGraphics.m_280168_();
            stack.m_85836_();
            Lighting.m_84930_();
            stack.m_252880_(56.0f, 53.0f, 0.0f);
            stack.m_252880_(-4.0f, 12.0f, 0.0f);
            stack.m_85841_(16.0f, -16.0f, 1.0f);
            stack.m_252781_(Axis.f_252529_.m_252977_(45.0f));
            stack.m_252781_(Axis.f_252436_.m_252977_(45.0f));
            MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
            if (!this.soils.isEmpty() && this.soil < this.soils.size()) {
                stack.m_85836_();
                Minecraft.m_91087_().m_91289_().m_110912_(this.soils.get(this.soil).m_49966_(), stack, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_);
                stack.m_85849_();
            }
            BakedModel model = AgriClientApi.getPlantModel(this.plantId, this.currentStage.index());
            stack.m_85836_();
            stack.m_252880_(0.0f, 1.0f, 0.0f);
            Minecraft.m_91087_().m_91289_().m_110937_().m_111067_(stack.m_85850_(), guiGraphics.m_280091_().m_6299_(RenderType.m_110457_()), null, model, 1.0f, 1.0f, 1.0f, 0xF000F0, OverlayTexture.f_118083_);
            stack.m_85849_();
            bufferSource.m_109911_();
            stack.m_85849_();
        });
        widgets.addTooltip((mouseX, mouseY) -> List.of(ClientTooltipComponent.m_169948_((FormattedCharSequence)Component.m_237110_((String)"agricraft.tooltip.jei.strength", (Object[])new Object[]{this.currentStrength}).m_7532_())), 104, 20, 9, 50);
        widgets.addTooltip((mouseX, mouseY) -> List.of(ClientTooltipComponent.m_169948_((FormattedCharSequence)Component.m_237110_((String)"agricraft.tooltip.jei.stage", (Object[])new Object[]{this.currentStage.index()}).m_7532_())), 92, 20, 9, 50);
        widgets.addTooltip((mouseX, mouseY) -> List.of(ClientTooltipComponent.m_169948_((FormattedCharSequence)Component.m_237110_((String)"agricraft.tooltip.jei.light", (Object[])new Object[]{15 - (mouseY - 26) / 3}).m_7532_())), 32, 26, 3, 47);
        widgets.addTooltip((mouseX, mouseY) -> {
            int offset = 0;
            for (int i = 0; i < HUMIDITY_OFFSETS.length; ++i) {
                if (37 + offset <= mouseX && mouseX <= 37 + offset + HUMIDITY_OFFSETS[i]) {
                    AgriSoilCondition.Humidity humidity = AgriSoilCondition.Humidity.values()[i];
                    return List.of(ClientTooltipComponent.m_169948_((FormattedCharSequence)Component.m_237115_((String)("agricraft.soil.humidity." + humidity.name().toLowerCase())).m_7532_()));
                }
                offset += HUMIDITY_OFFSETS[i];
            }
            return List.of();
        }, 37, 83, 53, 12);
        widgets.addTooltip((mouseX, mouseY) -> {
            int offset = 0;
            for (int i = 0; i < ACIDITY_OFFSETS.length; ++i) {
                if (37 + offset <= mouseX && mouseX <= 37 + offset + ACIDITY_OFFSETS[i]) {
                    AgriSoilCondition.Acidity acidity = AgriSoilCondition.Acidity.values()[i];
                    return List.of(ClientTooltipComponent.m_169948_((FormattedCharSequence)Component.m_237115_((String)("agricraft.soil.acidity." + acidity.name().toLowerCase())).m_7532_()));
                }
                offset += ACIDITY_OFFSETS[i];
            }
            return List.of();
        }, 37, 96, 52, 12);
        widgets.addTooltip((mouseX, mouseY) -> {
            int offset = 0;
            for (int i = 0; i < NUTRIENTS_OFFSETS.length; ++i) {
                if (37 + offset <= mouseX && mouseX <= 37 + offset + NUTRIENTS_OFFSETS[i]) {
                    AgriSoilCondition.Nutrients nutrients = AgriSoilCondition.Nutrients.values()[i];
                    return List.of(ClientTooltipComponent.m_169948_((FormattedCharSequence)Component.m_237115_((String)("agricraft.soil.nutrients." + nutrients.name().toLowerCase())).m_7532_()));
                }
                offset += NUTRIENTS_OFFSETS[i];
            }
            return List.of();
        }, 37, 109, 53, 12);
        Component desc = LangUtils.plantDescription(this.plantId);
        widgets.addTooltipText(desc == null ? List.of(LangUtils.plantName(this.plantId)) : List.of(LangUtils.plantName(this.plantId), desc), 50, 30, 26, 24);
        if (!this.soils.isEmpty() && this.soil < this.soils.size()) {
            widgets.addTooltip((mouseX, mouseY) -> Screen.m_280152_((Minecraft)Minecraft.m_91087_(), (ItemStack)new ItemStack((ItemLike)this.soils.get(this.soil))).stream().map(Component::m_7532_).map(ClientTooltipComponent::m_169948_).toList(), 50, 58, 26, 16);
        }
        if (AgriApi.getSeasonLogic().isActive()) {
            widgets.addTooltipText(List.of(LangUtils.seasonName(AgriSeason.SPRING)), 17, 24, 12, 12);
            widgets.addTooltipText(List.of(LangUtils.seasonName(AgriSeason.SUMMER)), 17, 37, 12, 12);
            widgets.addTooltipText(List.of(LangUtils.seasonName(AgriSeason.AUTUMN)), 17, 50, 12, 12);
            widgets.addTooltipText(List.of(LangUtils.seasonName(AgriSeason.WINTER)), 17, 63, 12, 12);
        }
    }

    public boolean incrementStrength() {
        this.currentStrength = Math.min(AgriApi.getStatRegistry().strengthStat().getMax(), this.currentStrength + 1);
        this.updateSoils();
        return true;
    }

    public boolean decrementStrength() {
        this.currentStrength = Math.max(AgriApi.getStatRegistry().strengthStat().getMin(), this.currentStrength - 1);
        this.updateSoils();
        return true;
    }

    public boolean incrementStage() {
        this.currentStage = this.currentStage.getNext(null, null);
        return true;
    }

    public boolean decrementStage() {
        this.currentStage = this.currentStage.getPrevious(null, null);
        return true;
    }

    public void updateSoils() {
        this.soils = AgriApi.getSoilRegistry().map(registry -> registry.m_123024_().filter(soil -> {
            boolean humidity = AgriGrowthConditionRegistry.getHumidity().apply(this.plant, this.currentStrength, soil.humidity()).isFertile();
            boolean acidity = AgriGrowthConditionRegistry.getAcidity().apply(this.plant, this.currentStrength, soil.acidity()).isFertile();
            boolean nutrients = AgriGrowthConditionRegistry.getNutrients().apply(this.plant, this.currentStrength, soil.nutrients()).isFertile();
            return humidity && acidity && nutrients;
        }).flatMap(soil -> soil.variants().stream()).flatMap(variant -> Platform.get().getBlocksFromLocation(variant.block()).stream()).distinct().toList()).orElse(List.of());
        this.soil = 0;
    }

    public static class Btn
    extends ButtonWidget {
        private final boolean isIncrement;

        protected Btn(int x, int y, int width, int height, BooleanSupplier onPress, boolean isIncrement) {
            super(x, y, width, height, 0, 0, () -> true, (mouseX, mouseY, button) -> onPress.getAsBoolean());
            this.isIncrement = isIncrement;
        }

        private int getUOffset(boolean isHovered) {
            if (Minecraft.m_91087_().f_91067_.m_91560_()) {
                return 9;
            }
            if (isHovered) {
                return 18;
            }
            return 0;
        }

        public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
            int vOffset = this.isIncrement ? 9 : 0;
            boolean isHovered = this.x <= mouseX && mouseX < this.x + this.width && this.y <= mouseY && mouseY < this.y + this.height;
            int uOffset = this.getUOffset(isHovered);
            guiGraphics.m_280163_(R_COMPONENTS, this.x, this.y, (float)uOffset, (float)vOffset, 9, 9, 128, 128);
        }
    }
}

