/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.datagen;

import com.agricraft.agricraft.api.AgriApi;
import com.agricraft.agricraft.datagen.FertilizersDatagen;
import com.agricraft.agricraft.datagen.LangDatagen;
import com.agricraft.agricraft.datagen.ModBlockTagProvider;
import com.agricraft.agricraft.datagen.ModItemTagProvider;
import com.agricraft.agricraft.datagen.ModRecipeProvider;
import com.agricraft.agricraft.datagen.ModelsDatagen;
import com.agricraft.agricraft.datagen.MutationsDatagen;
import com.agricraft.agricraft.datagen.PlantsDatagen;
import com.agricraft.agricraft.datagen.SoilsDatagen;
import com.agricraft.agricraft.datagen.WeedsDatagen;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.DetectedVersion;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.metadata.PackMetadataGenerator;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelProvider;
import net.minecraftforge.common.data.BlockTagsProvider;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="agricraft", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DatagenEventHandler {
    private static final boolean biomesoplenty = true;
    private static final boolean immersiveengineering = true;
    private static final boolean pamhc2crops = true;
    private static final boolean mysticalagriculture = true;
    private static final boolean farmersdelight = true;
    private static final boolean botania = true;

    @SubscribeEvent
    public static void onGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        generator.addProvider(event.includeServer(), ModRecipeProvider::new);
        BlockTagsProvider blockTagsProvider = (BlockTagsProvider)generator.addProvider(event.includeServer(), output -> new ModBlockTagProvider(output, event.getLookupProvider(), "agricraft", event.getExistingFileHelper()));
        generator.addProvider(event.includeServer(), output -> new ModItemTagProvider(output, event.getLookupProvider(), blockTagsProvider.m_274426_(), "agricraft", event.getExistingFileHelper()));
        generator.addProvider(event.includeServer(), output -> new DatapackBuiltinEntriesProvider(output, event.getLookupProvider(), new RegistrySetBuilder().m_254916_(AgriApi.AGRIPLANTS, PlantsDatagen::registerPlants).m_254916_(AgriApi.AGRISOILS, SoilsDatagen::registerSoils).m_254916_(AgriApi.AGRIMUTATIONS, MutationsDatagen::registerMutations).m_254916_(AgriApi.AGRIFERTILIZERS, FertilizersDatagen::registerFertilizers).m_254916_(AgriApi.AGRIWEEDS, WeedsDatagen::registerWeeds), Set.of("minecraft", "agricraft")));
        DatagenEventHandler.addProvider("minecraft", "crop", ModelsDatagen::registerMinecraftPlant, BlockModelBuilder::new, event.getGenerator(), event.getExistingFileHelper(), event.includeClient());
        DatagenEventHandler.addProvider("minecraft", "seed", ModelsDatagen::registerMinecraftSeed, ItemModelBuilder::new, event.getGenerator(), event.getExistingFileHelper(), event.includeClient());
        DatagenEventHandler.addProvider("agricraft", "crop", ModelsDatagen::registerAgricraftPlant, BlockModelBuilder::new, event.getGenerator(), event.getExistingFileHelper(), event.includeClient());
        DatagenEventHandler.addProvider("agricraft", "seed", ModelsDatagen::registerAgricraftSeed, ItemModelBuilder::new, event.getGenerator(), event.getExistingFileHelper(), event.includeClient());
        DatagenEventHandler.addProvider("agricraft", "weed", ModelsDatagen::registerAgricraftWeed, BlockModelBuilder::new, event.getGenerator(), event.getExistingFileHelper(), event.includeClient());
        DatagenEventHandler.addExtraDataPackProvider("biomesoplenty", new RegistrySetBuilder().m_254916_(AgriApi.AGRIPLANTS, PlantsDatagen::registerBiomesOPlenty).m_254916_(AgriApi.AGRIMUTATIONS, MutationsDatagen::registerBiomesOPlenty), ModelsDatagen::registerBiomesOPlentyPlant, ModelsDatagen::registerBiomesOPlentySeed, LangDatagen::biomesoplenty, event);
        DatagenEventHandler.addExtraDataPackProvider("immersiveengineering", new RegistrySetBuilder().m_254916_(AgriApi.AGRIPLANTS, PlantsDatagen::registerImmersiveEngineering).m_254916_(AgriApi.AGRIMUTATIONS, MutationsDatagen::registerImmersiveEngineering), ModelsDatagen::registerImmersiveEngineeringPlant, ModelsDatagen::registerImmersiveEngineeringSeed, LangDatagen::immersiveengineering, event);
        DatagenEventHandler.addExtraDataPackProvider("pamhc2crops", new RegistrySetBuilder().m_254916_(AgriApi.AGRIPLANTS, PlantsDatagen::registerPamsHarvestCraft2).m_254916_(AgriApi.AGRIMUTATIONS, MutationsDatagen::registerPamsHarvestCraft2), ModelsDatagen::registerPamsHarvestCraft2Plant, ModelsDatagen::registerPamsHarvestCraft2Seed, LangDatagen::pamhc2crops, event);
        DatagenEventHandler.addExtraDataPackProvider("mysticalagriculture", new RegistrySetBuilder().m_254916_(AgriApi.AGRIPLANTS, PlantsDatagen::registerMysticalAgriculture).m_254916_(AgriApi.AGRISOILS, SoilsDatagen::registerMysticalAgriculture).m_254916_(AgriApi.AGRIFERTILIZERS, FertilizersDatagen::registerMysticalAgriculture), ModelsDatagen::registerMysticalAgriculturePlant, ModelsDatagen::registerMysticalAgricultureSeed, LangDatagen::mysticalagriculture, event);
        DatagenEventHandler.addExtraDataPackProvider("farmersdelight", new RegistrySetBuilder().m_254916_(AgriApi.AGRIPLANTS, PlantsDatagen::registerFarmersDelight).m_254916_(AgriApi.AGRIMUTATIONS, MutationsDatagen::registerFarmersDelight).m_254916_(AgriApi.AGRISOILS, SoilsDatagen::registerFarmersDelight), ModelsDatagen::registerFarmersDelightPlant, ModelsDatagen::registerFarmersDelightSeed, LangDatagen::farmersdelight, event);
        DatagenEventHandler.addExtraDataPackProvider("botania", new RegistrySetBuilder().m_254916_(AgriApi.AGRIPLANTS, PlantsDatagen::registerBotania).m_254916_(AgriApi.AGRIMUTATIONS, MutationsDatagen::registerBotania), ModelsDatagen::registerBotaniaPlant, ModelsDatagen::registerBotaniaSeed, LangDatagen::botania, event);
    }

    private static <T extends ModelBuilder<T>> void addProvider(String modid, String folder, final Consumer<ModelProvider<T>> consumer, BiFunction<ResourceLocation, ExistingFileHelper, T> builderFromModId, DataGenerator generator, ExistingFileHelper existingFileHelper, boolean includeClient) {
        generator.addProvider(includeClient, (DataProvider)new ModelProvider<T>(generator.getPackOutput(), modid, folder, builderFromModId, existingFileHelper){

            protected void registerModels() {
                consumer.accept(this);
            }

            public String m_6055_() {
                return "Models for: %s:%s".formatted(this.modid, this.folder);
            }
        });
    }

    private static void addExtraDataPackProvider(final String modid, RegistrySetBuilder registrySetBuilder, final Consumer<ModelProvider<BlockModelBuilder>> blockModels, final Consumer<ModelProvider<ItemModelBuilder>> seedModels, final Consumer<LanguageProvider> translations, GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput dataOutput = generator.getPackOutput("datapacks/" + modid);
        generator.addProvider(event.includeServer(), output -> new PackMetadataGenerator(dataOutput){

            public String m_6055_() {
                return "DataPack Metadata " + modid;
            }
        }.m_247300_(PackMetadataSection.f_243696_, (Object)new PackMetadataSection((Component)Component.m_237115_((String)("agricraft.datapacks." + modid)), DetectedVersion.f_132476_.m_264084_(PackType.SERVER_DATA), Map.of())));
        generator.addProvider(event.includeServer(), output -> new DatapackBuiltinEntriesProvider(dataOutput, event.getLookupProvider(), registrySetBuilder, Set.of(modid)){

            public String m_6055_() {
                return "Registries " + modid;
            }
        });
        PackOutput resourceOutput = generator.getPackOutput("resourcepacks/" + modid);
        generator.addProvider(event.includeClient(), output -> new PackMetadataGenerator(resourceOutput){

            public String m_6055_() {
                return "ResourcePack Metadata " + modid;
            }
        }.m_247300_(PackMetadataSection.f_243696_, (Object)new PackMetadataSection((Component)Component.m_237115_((String)("agricraft.resourcepacks." + modid)), DetectedVersion.f_132476_.m_264084_(PackType.CLIENT_RESOURCES), Map.of())));
        generator.addProvider(event.includeClient(), (DataProvider)new ModelProvider<BlockModelBuilder>(resourceOutput, modid, "crop", BlockModelBuilder::new, event.getExistingFileHelper()){

            protected void registerModels() {
                blockModels.accept(this);
            }

            public String m_6055_() {
                return "Crop Models for " + this.modid;
            }
        });
        generator.addProvider(event.includeClient(), (DataProvider)new ModelProvider<ItemModelBuilder>(resourceOutput, modid, "seed", ItemModelBuilder::new, event.getExistingFileHelper()){

            protected void registerModels() {
                seedModels.accept(this);
            }

            public String m_6055_() {
                return "Seed Models for " + this.modid;
            }
        });
        generator.addProvider(event.includeClient(), (DataProvider)new LanguageProvider(resourceOutput, modid, "en_us"){

            public String m_6055_() {
                return "Languages: en_us for " + modid;
            }

            protected void addTranslations() {
                translations.accept(this);
            }
        });
    }
}

