/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.refurbished.block.FurnitureEntityBlock;
import com.mrcrayfish.furniture.refurbished.block.MetalType;
import com.mrcrayfish.furniture.refurbished.blockentity.CeilingFanBlockEntity;
import com.mrcrayfish.furniture.refurbished.data.tag.BlockTagSupplier;
import com.mrcrayfish.furniture.refurbished.util.VoxelShapeHelper;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CeilingFanBlock
extends FurnitureEntityBlock
implements BlockTagSupplier {
    private final WoodType woodType;
    private final MetalType metalType;

    public CeilingFanBlock(WoodType woodType, MetalType metalType, BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
        this.woodType = woodType;
        this.metalType = metalType;
    }

    public WoodType getWoodType() {
        return this.woodType;
    }

    public MetalType getMetalType() {
        return this.metalType;
    }

    @Override
    protected Map<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape ceilingShape = Block.m_49796_((double)5.0, (double)7.5, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
        VoxelShape wallShape = Block.m_49796_((double)7.5, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0);
        VoxelShape floorShape = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)8.5, (double)11.0);
        return ImmutableMap.copyOf(states.stream().collect(Collectors.toMap(state -> state, state -> switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.UP -> ceilingShape;
            case Direction.DOWN -> floorShape;
            default -> VoxelShapeHelper.rotateHorizontally(wallShape, (Direction)state.m_61143_((Property)FACING));
        })));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_43719_().m_122424_());
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf((Boolean)state.m_61143_((Property)LIT) == false)), 3);
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING});
        builder.m_61104_(new Property[]{POWERED});
        builder.m_61104_(new Property[]{LIT});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CeilingFanBlockEntity(pos, state);
    }

    @Override
    public List<TagKey<Block>> getTags() {
        return List.of(BlockTags.f_144282_);
    }

    public static int light(BlockState state) {
        return (Boolean)state.m_61143_((Property)POWERED) != false && (Boolean)state.m_61143_((Property)LIT) != false ? 15 : 0;
    }
}

