/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.part;

import javax.annotation.Nullable;
import mrtjp.projectred.api.IConnectable;
import mrtjp.projectred.core.RedstonePropagator;
import mrtjp.projectred.core.part.IConnectableCenterPart;
import mrtjp.projectred.core.part.IPropagationHooks;
import mrtjp.projectred.core.part.IPropagationPart;

public interface IPropagationCenterPart
extends IPropagationHooks,
IConnectableCenterPart {
    default public void propagateOther(int mode) {
    }

    @Override
    default public void propagateForward(@Nullable IPropagationPart prev, int mode) {
        if (mode != 3) {
            RedstonePropagator.addPartChange(this);
        }
        for (int s = 0; s < 6; ++s) {
            if ((this.getPropagationMask() & 1 << s) == 0) continue;
            if (this.maskConnectsIn(s)) {
                this.propagateTo(this.getInternal(s), prev, mode);
                continue;
            }
            if (!this.maskConnectsOut(s) || this.propagateTo(this.getStraight(s), prev, mode)) continue;
            RedstonePropagator.addNeighborChange(this.level(), this.pos(), this.posOfStraight(s));
        }
        this.propagateOther(mode);
    }

    @Override
    default public void propagateBackward(@Nullable IPropagationPart prev, int mode) {
        if (prev != null && this.shouldPropagate(prev, mode)) {
            RedstonePropagator.propagateTo(prev, this, mode);
        }
    }

    default public boolean propagateTo(@Nullable IConnectable to, @Nullable IPropagationPart prev, int mode) {
        if (to != null) {
            IPropagationPart part;
            if (to == prev) {
                return false;
            }
            if (to instanceof IPropagationPart && this.shouldPropagate(part = (IPropagationPart)((Object)to), mode)) {
                RedstonePropagator.propagateTo(part, this, mode);
                return true;
            }
        }
        return false;
    }

    default public int getPropagationMask() {
        return 63;
    }
}

