/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import snownee.jade.JadeClient;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.impl.ui.TextElement;
import snownee.jade.util.ModIdentification;
import snownee.jade.util.WailaExceptionHandler;

public enum ItemTooltipProvider implements IEntityComponentProvider
{
    INSTANCE;


    @Override
    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
        ItemStack stack = ((ItemEntity)accessor.getEntity()).m_32055_();
        JadeClient.hideModName = true;
        ArrayList lines = Lists.newArrayList();
        try {
            stack.m_41651_(null, (TooltipFlag)TooltipFlag.Default.f_256752_).stream().peek(component -> {
                MutableComponent mutable;
                if (component instanceof MutableComponent && (mutable = (MutableComponent)component).m_7383_().m_131135_() != null) {
                    mutable.m_6270_(mutable.m_7383_().m_131148_((TextColor)null));
                }
            }).map(Either::left).forEach(lines::add);
        }
        catch (Throwable e) {
            String namespace = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()).m_135827_();
            WailaExceptionHandler.handleErr(e, this, tooltip, namespace);
        }
        JadeClient.hideModName = false;
        if (lines.isEmpty()) {
            return;
        }
        List<FormattedText> realLines = lines.stream().map($ -> $.left()).filter(Optional::isPresent).map(Optional::get).skip(1L).toList();
        String modName = ModIdentification.getModName(stack);
        Font font = Minecraft.m_91087_().f_91062_;
        int maxWidth = 250;
        for (FormattedText text : realLines) {
            if (Objects.equals(ChatFormatting.m_126649_((String)text.getString()), modName)) continue;
            int width = font.m_92852_(text);
            if (width > maxWidth) {
                tooltip.add((Component)Component.m_237113_((String)(font.m_92854_(text, maxWidth - 5).getString() + "..")));
                continue;
            }
            tooltip.add(new TextElement(text));
        }
    }

    @Override
    public ResourceLocation getUid() {
        return Identifiers.MC_ITEM_TOOLTIP;
    }
}

