/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.inventory;

import com.brandon3055.brandonscore.utils.ItemNBTHelper;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;

public class InvJunkFilter
implements IItemHandlerModifiable {
    private ItemStack stack;
    private NonNullList<ItemStack> stacks;

    public InvJunkFilter(ItemStack stack, int filterSize) {
        this.stack = stack;
        this.stacks = NonNullList.m_122780_((int)filterSize, (Object)ItemStack.f_41583_);
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return stack.m_41720_() instanceof BlockItem;
    }

    public int getSlots() {
        return this.stacks.size();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return ItemStack.f_41583_;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        return null;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return null;
    }

    public int getSlotLimit(int slot) {
        return 0;
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
    }

    public void saveItems() {
        if (this.stack == null) {
            LogHelperBC.bigError((String)"TolkienTweaks: Tried to load Dynamic Item Stack inventory from null item!", (Object[])new Object[0]);
            return;
        }
        CompoundTag compound = ItemNBTHelper.getCompound((ItemStack)this.stack);
        ListTag list = new ListTag();
        for (ItemStack stack : this.stacks) {
            if (stack == null || stack.m_41613_() <= 0) continue;
            CompoundTag tag = new CompoundTag();
            stack.m_41739_(tag);
            list.add((Object)tag);
        }
        compound.m_128365_("InvItems", (Tag)list);
    }

    public void loadItems() {
        if (this.stack == null) {
            LogHelperBC.bigError((String)"TolkienTweaks: Tried to save Dynamic Item Stack inventory to null item!", (Object[])new Object[0]);
            return;
        }
        CompoundTag compound = ItemNBTHelper.getCompound((ItemStack)this.stack);
        ListTag list = compound.m_128437_("InvItems", 10);
        this.stacks.clear();
        for (int i = 0; i < list.size(); ++i) {
            this.stacks.add((Object)ItemStack.m_41712_((CompoundTag)list.m_128728_(i)));
        }
    }
}

