/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.blocks.electricity.voltmeter.energy_meter;

import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyMeterBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    public LerpedFloat angle = LerpedFloat.angular();
    public int energy = 0;
    public int range = 1;

    public EnergyMeterBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public void tick() {
        float value;
        super.tick();
        Direction direction = ((Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122424_();
        BlockEntity beBehind = this.f_58857_.m_7702_(this.m_58899_().m_121945_(direction));
        if (beBehind != null) {
            if (beBehind.getCapability(ForgeCapabilities.ENERGY).isPresent()) {
                this.energy = ((IEnergyStorage)beBehind.getCapability(ForgeCapabilities.ENERGY).orElse((Object)new EnergyStorage(0))).getEnergyStored();
                this.range = ((IEnergyStorage)beBehind.getCapability(ForgeCapabilities.ENERGY).orElse((Object)new EnergyStorage(0))).getMaxEnergyStored();
            } else {
                this.energy = 0;
            }
        }
        if ((value = (float)Math.abs(this.energy) / (float)this.getRange()) > 1.0f) {
            value = 1.0f;
        }
        float targetAngle = value * 180.0f;
        this.angle.chase((double)targetAngle, (double)0.05f, LerpedFloat.Chaser.EXP);
        this.angle.tickChaser();
    }

    public int getRange() {
        return this.range;
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128405_("range", this.range);
        compound.m_128350_("angle", (float)Math.abs(this.energy) / (float)this.getRange());
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.range = compound.m_128451_("range");
        this.angle.setValue((double)compound.m_128457_("angle"));
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        Lang.translate((String)"goggles.energy_meter", (Object[])new Object[0]).style(ChatFormatting.DARK_GRAY).forGoggles(tooltip, 1);
        Lang.translate((String)"goggles.energy_meter.energy", (Object[])new Object[]{this.energy}).style(ChatFormatting.AQUA).forGoggles(tooltip, 1);
        Lang.translate((String)"goggles.energy_meter.energy", (Object[])new Object[]{Float.valueOf(this.angle.getValue())}).style(ChatFormatting.AQUA);
        return true;
    }
}

