/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.common.event;

import cofh.core.init.CoreMobEffects;
import cofh.lib.common.effect.CustomParticleMobEffect;
import cofh.lib.common.effect.MobEffectCoFH;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.living.PotionColorCalculationEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="cofh_core")
public class EffectEvents {
    private static final int CLARITY_MOD = 20;

    private EffectEvents() {
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleChorusFruitTeleportEvent(EntityTeleportEvent.ChorusFruit event) {
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        if (entity.m_21023_((MobEffect)CoreMobEffects.ENDERFERENCE.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleEnderEntityTeleportEvent(EntityTeleportEvent.EnderEntity event) {
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        if (entity.m_21023_((MobEffect)CoreMobEffects.ENDERFERENCE.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleEnderPearlTeleportEvent(EntityTeleportEvent.EnderPearl event) {
        if (event.isCanceled()) {
            return;
        }
        ServerPlayer entity = event.getPlayer();
        if (entity.m_21023_((MobEffect)CoreMobEffects.ENDERFERENCE.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleEntityStruckByLightningEvent(EntityStruckByLightningEvent event) {
        if (event.isCanceled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (living.m_21023_((MobEffect)CoreMobEffects.LIGHTNING_RESISTANCE.get())) {
                event.setCanceled(true);
            } else {
                living.m_7292_(new MobEffectInstance((MobEffect)CoreMobEffects.SHOCKED.get(), 100, 0));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handlePotionColorEvent(PotionColorCalculationEvent event) {
        Collection effects = event.getEffects();
        if (effects.isEmpty()) {
            return;
        }
        Predicate<MobEffectInstance> hasCustomParticle = effect -> effect.m_19544_() instanceof CustomParticleMobEffect;
        if (effects.stream().anyMatch(hasCustomParticle)) {
            List<MobEffectInstance> nonCustom = effects.stream().filter(hasCustomParticle.negate()).toList();
            if (nonCustom.isEmpty()) {
                event.shouldHideParticles(true);
            } else {
                event.setColor(PotionUtils.m_43564_(nonCustom));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void handlePotionAddEvent(MobEffectEvent.Added event) {
        if (event.isCanceled()) {
            return;
        }
        MobEffectInstance instance = event.getEffectInstance();
        MobEffect mobEffect = instance.m_19544_();
        if (mobEffect instanceof MobEffectCoFH) {
            MobEffectCoFH effect = (MobEffectCoFH)mobEffect;
            effect.onApply(event.getEntity(), instance);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void handlePotionTrackEvent(PlayerEvent.StartTracking event) {
        if (event.isCanceled()) {
            return;
        }
        Entity entity = event.getTarget();
        if (entity instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            for (MobEffectInstance instance : entity2.m_21220_()) {
                MobEffect mobEffect = instance.m_19544_();
                if (!(mobEffect instanceof MobEffectCoFH)) continue;
                MobEffectCoFH effect = (MobEffectCoFH)mobEffect;
                effect.onTrack(entity2, instance, event.getEntity());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void handlePotionRemoveEvent(MobEffectEvent.Remove event) {
        MobEffect mobEffect;
        if (event.isCanceled()) {
            return;
        }
        MobEffectInstance instance = event.getEffectInstance();
        if (instance != null && (mobEffect = instance.m_19544_()) instanceof MobEffectCoFH) {
            MobEffectCoFH effect = (MobEffectCoFH)mobEffect;
            effect.onRemove(event.getEntity(), instance);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void handlePotionExpiredEvent(MobEffectEvent.Expired event) {
        MobEffect mobEffect;
        if (event.isCanceled()) {
            return;
        }
        MobEffectInstance instance = event.getEffectInstance();
        if (instance != null && (mobEffect = instance.m_19544_()) instanceof MobEffectCoFH) {
            MobEffectCoFH effect = (MobEffectCoFH)mobEffect;
            effect.onExpire(event.getEntity(), instance);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleTargetChangeEvent(LivingEvent.LivingVisibilityEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.m_21023_((MobEffect)CoreMobEffects.TRUE_INVISIBILITY.get())) {
            float armor = Math.max(entity.m_21207_(), 0.1f) * 0.7f;
            event.modifyVisibility((double)(0.07f / armor));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleXpChangeEvent(PlayerXpEvent.XpChange event) {
        if (event.isCanceled() || event.getAmount() <= 0) {
            return;
        }
        Player player = event.getEntity();
        MobEffectInstance clarityEffect = player.m_21124_((MobEffect)CoreMobEffects.CLARITY.get());
        if (clarityEffect == null) {
            return;
        }
        event.setAmount(Math.max(event.getAmount(), EffectEvents.getXPValue(event.getAmount(), clarityEffect.m_19564_())));
    }

    private static int getXPValue(int baseExp, int amplifier) {
        return baseExp * (100 + 20 * (1 + amplifier)) / 100;
    }
}

